/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.sfsb.util;

import java.security.SecureRandom;

import com.sun.ejb.spi.sfsb.util.SFSBUUIDUtil;
import com.sun.enterprise.util.Utility;

/**
 * A utility class that generates stateful session keys using two longs
 * The session id generated by this class is guarenteed to be unique as 
 * long as the system clock is never reset to a previous value
 * 
 * The hashCode of the SessionKey generated by ScrambledKeyGenerator 
 * also allows uniform distribution of keys when hashed in a HashMap
 *
 * @author  Mahesh Kannan
 */
public class ScrambledKeyGenerator
    extends SimpleKeyGenerator
{
   
    private SecureRandom random = new SecureRandom();
    private int cachedTime = (int) System.currentTimeMillis();

    public ScrambledKeyGenerator() {
	init((int) System.currentTimeMillis(), System.identityHashCode(this));
    }

    public ScrambledKeyGenerator(byte[] ipAddress, int port) {
	init(Utility.bytesToInt(ipAddress, 0), port);
    }

    public ScrambledKeyGenerator(long val) {
	init((int) (val >>> 32), (int) ((val << 32) >>> 32));
    }

    private void init(int hi, int lo) {
	byte[] hiBytes = new byte[4];
	Utility.intToBytes(hi, hiBytes, 0);
	byte[] loBytes = new byte[4];
	Utility.intToBytes(lo, loBytes, 0);

	swapBytes(hiBytes, loBytes, 2, 3);
	swapBytes(loBytes, loBytes, 2, 3);
	swapBytes(hiBytes, loBytes, 3, 0);
	swapBytes(hiBytes, hiBytes, 0, 3);
	swapBytes(hiBytes, loBytes, 1, 3);

	swapBytes(hiBytes, hiBytes, 0, 1);
	swapBytes(loBytes, loBytes, 2, 3);

        this.prefix = Utility.bytesToInt(hiBytes, 0);
	this.prefix <<= 32;
	
        this.suffix = Utility.bytesToInt(loBytes, 0);
	this.suffix <<= 32;

        //Inital isCounter value
        this.idCounter = 0;

        //Set the default time value
        this.cachedTime = (int) System.currentTimeMillis();
    }

    private static final void swapBytes(byte[] a, byte[] b,
	    int index1, int index2)
    {
	byte temp = a[index1];
	a[index1] = b[index2];
	b[index2] = temp;
    }

    /**
     * Create and return the sessionKey.
     * @return the sessionKey object
     */
    public Object createSessionKey() {
        int id = 0;
        synchronized (this) {
            id = ++idCounter;
            if (id < 0) {
                //idCounter wrapped around!!
                id = idCounter = 1;
	    }

	    if ((id & 0x000000FF) == 0) {
                cachedTime = (int) System.currentTimeMillis();
            }
        }
	
	return new SimpleSessionKey(
	    prefix + cachedTime,
	    //suffix + System.identityHashCode(new Object()), id
	    suffix + random.nextInt(), id
	);
    }
    
}
    
