/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb;

import java.util.Enumeration;
import java.rmi.Remote;

import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityManager;

import javax.ejb.*;
import javax.ejb.spi.HandleDelegate;
import javax.transaction.TransactionManager;
import com.sun.enterprise.deployment.EjbDescriptor;

import com.sun.enterprise.config.ConfigContext;

/**
 * ContainerFactory creates the appropriate Container instance
 * (StatefulSessionContainer, StatelessSessionContainer, EntityContainer, 
 * MessageBeanContainer) and initializes it.
 *
 * It is also a factory for EJBObject/Home instances which are needed
 * by the Protocol Manager when a remote invocation arrives.
 *
 */
public interface ContainerFactory {
    /**
     * Create the appropriate Container instance and initialize it.
     * @param ejbDescriptor the deployment descriptor of the EJB
			    for which a container is to be created.
     */
    Container createContainer(EjbDescriptor ejbDescriptor, 
			      ClassLoader loader, 
			      com.sun.enterprise.SecurityManager sm,
			      ConfigContext dynamicConfigContext)
	throws Exception;

    /**
     * Get the container instance corresponding to the given EJB id.
     */
    Container getContainer(long ejbId);

    /**
     * Remove the container instance corresponding to the given EJB id.
     */
    public void removeContainer(long ejbId);

    /**
     * List all container instances in this JVM.
     */
    public Enumeration listContainers();

    /**
     * Return the container factory's TransactionManager object.
     * Called from SerialContext during JNDI lookup at 
     * "java:pm/TransactionManager". Note that the container's
     * TransactionManager is a wrapper over the real TM.
     */
    public TransactionManager getTransactionMgr();

    /**
     * Return the EjbDescriptor for the given ejbId.
     */
    public EjbDescriptor getEjbDescriptor(long ejbId);


    public Object getEJBContextObject(String contextType);


    /**
     * Register an EntityManager with EXTENDED persistence context for
     * the current ejb component.  Only applicable for stateful session
     * beans.
     */
    public EntityManager lookupExtendedEntityManager(EntityManagerFactory factory);

    /**
     * EJB Timer Service operations.
     */
    public void initEJBTimerService() throws Exception;
    public void restoreEJBTimers() throws Exception;
    public void shutdownEJBTimerService();

}
