/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * EjbVisitor.java
 *
 * Created on January 31, 2002, 11:28 AM
 */

package com.sun.enterprise.deployment.util;

import java.util.Iterator;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.FieldDescriptor;
import com.sun.enterprise.deployment.QueryDescriptor;

/**
 * This class is responsible for visiting DOL ejb related  descritpors
 * 
 * @author  Jerome Dochez
 * @version 
 */
public interface EjbVisitor extends ComponentVisitor {
    
    /**
     * visits an ejb descriptor
     * @param ejb descriptor
     */
    public void accept(EjbDescriptor ejb);
    
    /**
     * visits a method permission and permitted methods for the 
     * last J2ee component visited
     * @param method permission 
     * @param the methods associated with the above permission
     */
    public void accept(MethodPermission pm, Iterator methods);

    /**
     * visits a method transaction 
     * @param ejb descritptor this method applies to
     * @param method descriptor the method
     * @param container transaction
     */
    public void accept(MethodDescriptor method, ContainerTransaction ct);
    
    /**
     * visits a CMP field definition (for CMP entity beans)
     * @param field descriptor for the CMP field
     */
    public void accept(FieldDescriptor fd);
    
    /**
     * visits a query method 
     * @param method descriptor for the method
     * @param query descriptor 
     */
    public void accept(MethodDescriptor method, QueryDescriptor qd);    

}

