/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.types;

import com.sun.enterprise.deployment.web.ContextParameter;

import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;

/** 
 * Protocol associated with defining an EJB Interface
 *
 * @author Kenneth Saks
 */

public interface MessageDestinationReference extends MessageDestinationReferencer, NamedInformation {

    public static String CONSUMES = "Consumes";
    public static String PRODUCES = "Produces";
    public static String CONSUMES_AND_PRODUCES = "ConsumesProduces";

    /** 
     * @return the type of the message destination reference
     */
    public String getType();

    /**
     * @param type the type of the message destination reference
     */
    public void setType(String type);

    /**
     * @return the usage type of the message destination reference
     * (Consumes, Produces, ConsumesProduces)
     */
    public String getUsage();

    /**
     * @param usage the usage type of the message destination reference
     * (Consumes, Produces, ConsumesProduces)
     */
    public void setUsage(String usage);

    /**
     * Set the referring bundle, i.e. the bundle within which this
     * message destination reference is declared. 
     */
    public void setReferringBundleDescriptor(BundleDescriptor referringBundle);

    /**
     * Get the referring bundle, i.e. the bundle within which this
     * message destinaion reference is declared.  
     */
    public BundleDescriptor getReferringBundleDescriptor();

}

