/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

    
package com.sun.enterprise.deployment.runtime;
    
import com.sun.enterprise.deployment.Descriptor;

public class IASEjbCMPFinder extends Descriptor {
    
      private String method_name = null;
      private String query_params = null;
      private String query_filter = null;
      private String query_variables = null;
      private String query_ordering = null;
      
      public IASEjbCMPFinder () {
      }
      
      public IASEjbCMPFinder(String method_name, String params, String filter) {
        this.method_name = method_name;
        this.query_params = params;
        this.query_filter = filter;
        this.query_variables = "";
      }

      public IASEjbCMPFinder(String method_name, String params, String filter, String variables) {
        this.method_name = method_name;
        this.query_params = params;
        this.query_filter = filter;
        this.query_variables = variables;
      }
      
      public String getMethodName() {
        return method_name;
      }
      
      public String getQueryParameterDeclaration() {
        return query_params;
      }

      public String getQueryFilter() {
        return query_filter;
      }
 
      public String getQueryVariables() {
        return query_variables;
      }
      
      public void setMethodName(String name) {
        method_name = name;
      }
      
      public void setQueryParameterDeclaration(String qry) {
        query_params = qry;
      }
 
      public void setQueryVariables(String qryvariables) {
        query_variables = qryvariables;
      }
      
      public void setQueryFilter(String qryfilter) {
        query_filter = qryfilter;
      }
      
      public String getQueryOrdering() {
	  return query_ordering;
      }
      
      public void setQueryOrdering(String qryordering) {
	  query_ordering = qryordering;
      }
}
      
