/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * @(#) BeanPool.java
 *
 * Copyright 2000-2001 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of iPlanet/Sun Microsystems, Inc. ("Confidential Information").
 * You shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with iPlanet/Sun Microsystems.
 */
package com.sun.enterprise.deployment.runtime;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.DescriptorConstants;

/** iAS specific DD Element (see the ias-ejb-jar_2_0.dtd for this element)
 * @author Ludo
 * @since JDK 1.4
 */
public class BeanPoolDescriptor extends Descriptor implements DescriptorConstants {
       
    private int maxPoolSize = MAX_POOL_SIZE_DEFAULT;
    private int poolIdleTimeoutInSeconds = POOL_IDLE_TIMEOUT_DEFAULT;
    private int maxWaitTimeInMillis = MAX_WAIT_TIME_DEFAULT;
    private int poolResizeQuantity = POOL_RESIZE_QTY_DEFAULT;
    private int steadyPoolSize = STEADY_POOL_SIZE_DEFAULT;

    
    /** Default constructor. */
    public BeanPoolDescriptor() {
    }

     /** Getter for property poolIdleTimeoutInSeconds.
     * @return Value of property idleTimeoutInSeconds.
     */
    public int getPoolIdleTimeoutInSeconds() {
        return poolIdleTimeoutInSeconds;
    }    
    
    /** Setter for property poolIdleTimeoutInSeconds.
     * @param poolIdleTimeoutInSeconds New value of property poolIdleTimeoutInSeconds.
     */
    public void setPoolIdleTimeoutInSeconds(int poolIdleTimeoutInSeconds) {
        this.poolIdleTimeoutInSeconds = poolIdleTimeoutInSeconds;
    }
    
    /** Getter for property maxPoolSize.
     * @return Value of property maxPoolSize.
     */
    public int getMaxPoolSize() {
        return maxPoolSize;
    }
    
    /** Setter for property maxPoolSize.
     * @param maxPoolSize New value of property maxPoolSize.
     */
    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }
    
    /** Getter for property maxWaitTimeInMillis.
     * @return Value of property maxWaitTimeInMillis.
     */
    public int getMaxWaitTimeInMillis() {
        return maxWaitTimeInMillis;
    }
    
    /** Setter for property maxWaitTimeInMillis.
     * @param maxWaitTimeInMillis New value of property maxWaitTimeInMillis.
     */
    public void setMaxWaitTimeInMillis(int maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis = maxWaitTimeInMillis;
    }
    
    /** Getter for property poolResizeQuantity
     * @return Value of property poolResizeQuantity.
     */
    public int getPoolResizeQuantity() {
        return poolResizeQuantity;
    }
    
    /** Setter for property poolResizeQuantity.
     * @param poolResizeQuantity New value of property poolResizeQuantity.
     */
    public void setPoolResizeQuantity(int poolResizeQuantity) {
        this.poolResizeQuantity = poolResizeQuantity;
    }   
    
    /** Getter for property steadyPoolSize
    * @return Value of property steadyPoolSize.
    */
    public int getSteadyPoolSize() {
        return steadyPoolSize;
    }
  
    /** Setter for property steadyPoolSize.
     * @param steadyPoolSize New value of property steadyPoolSize.
     */
    public void setSteadyPoolSize(int steadyPoolSize) {
        this.steadyPoolSize = steadyPoolSize;
    }
}

