/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SecurityConstraintNode.java
 *
 * Created on March 1, 2002, 2:24 PM
 */

package com.sun.enterprise.deployment.node.web;

import java.util.Enumeration;
import java.util.Map;
import org.w3c.dom.Node;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebResourceCollectionImpl;
import com.sun.enterprise.deployment.AuthorizationConstraintImpl;
import com.sun.enterprise.deployment.UserDataConstraintImpl;
import com.sun.enterprise.deployment.xml.WebTagNames;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;

/** 
 * This node handles the security-contraint xml tag
 *
 * @author  Jerome Dochez
 * @version 
 */
public class SecurityConstraintNode extends DeploymentDescriptorNode {

    public SecurityConstraintNode() {
        super();
        registerElementHandler(new XMLElement(WebTagNames.USERDATA_CONSTRAINT), 
                    UserDataConstraintNode.class, "setUserDataConstraint");
        registerElementHandler(new XMLElement(WebTagNames.AUTH_CONSTRAINT),         
                    AuthConstraintNode.class, "setAuthorizationConstraint");
        registerElementHandler(new XMLElement(WebTagNames.WEB_RESOURCE_COLLECTION),         
                    WebResourceCollectionNode.class, "addWebResourceCollection");        
    }
    
    /**
     * all sub-implementation of this class can use a dispatch table to map 
     * xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a 
     * value
     */    
    protected Map getDispatchTable() {    
        Map table = super.getDispatchTable();
        table.put(WebTagNames.NAME, "setName");
	return table;
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node in the DOM tree 
     * @param node name for the root element of this xml fragment      
     * @param the descriptor to write
     * @return the DOM tree top node
     */
    public Node writeDescriptor(Node parent, String nodeName, SecurityConstraintImpl descriptor) {
        Node myNode = appendChild(parent, nodeName);
        appendTextChild(myNode, WebTagNames.NAME, descriptor.getName());
        
        // web-resource-collection+
        WebResourceCollectionNode wrcNode = new WebResourceCollectionNode();
        for (Enumeration webResources = descriptor.getWebResourceCollections(); 
            webResources.hasMoreElements();) {
                wrcNode.writeDescriptor(myNode, WebTagNames.WEB_RESOURCE_COLLECTION, 
                    (WebResourceCollectionImpl) webResources.nextElement());
        }
        
        // auth-constaint?
        AuthorizationConstraintImpl aci = (AuthorizationConstraintImpl) descriptor.getAuthorizationConstraint();
        if (aci!=null) {
            AuthConstraintNode acNode = new AuthConstraintNode();
            acNode.writeDescriptor(myNode, WebTagNames.AUTH_CONSTRAINT, aci);
        }
        
        // user-data-constraint?
        UserDataConstraintImpl udci = (UserDataConstraintImpl) descriptor.getUserDataConstraint();
        if (udci!=null) {
            UserDataConstraintNode udcn = new UserDataConstraintNode();
            udcn.writeDescriptor(myNode, WebTagNames.USERDATA_CONSTRAINT, udci);
        }
        return myNode;        
    }
    
}