/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;

/**
* superclass node for WebProperty container 
*
* @author Jerome Dochez
*/
public class SessionManagerNode extends WebRuntimeNode {

    /**
     * Initialize the child handlers
     */
    public SessionManagerNode() {
	
        registerElementHandler(new XMLElement(RuntimeTagNames.MANAGER_PROPERTIES), 
                               WebPropertyContainerNode.class, "setManagerProperties");	
        registerElementHandler(new XMLElement(RuntimeTagNames.STORE_PROPERTIES), 
                               WebPropertyContainerNode.class, "setStoreProperties");				       
    }
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
	RuntimeDescriptor descriptor = getRuntimeDescriptor();
	if (descriptor==null) {
	    throw new RuntimeException("Trying to set values on a null descriptor");
	}
	if (element.getQName().equals(RuntimeTagNames.PERSISTENCE_TYPE)) {
	    descriptor.setAttributeValue(SessionManager.PERSISTENCE_TYPE, value);
	}
    }   

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, SessionManager descriptor) {
	
	Element sessionMgr = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	
	// manager-properties?
	if (descriptor.getManagerProperties()!=null) {
	    WebPropertyNode wpn = new WebPropertyNode();
	    Node mgrProps = appendChild(sessionMgr, RuntimeTagNames.MANAGER_PROPERTIES);
	    wpn.writeDescriptor(mgrProps, RuntimeTagNames.PROPERTY, descriptor.getManagerProperties().getWebProperty());
	}
	
	// store-properties?
	if (descriptor.getStoreProperties()!=null) {
	    WebPropertyNode wpn = new WebPropertyNode();
	    Node storeProps = appendChild(sessionMgr, RuntimeTagNames.STORE_PROPERTIES);
	    wpn.writeDescriptor(storeProps, RuntimeTagNames.PROPERTY, descriptor.getStoreProperties().getWebProperty());
	}
	
	// persistence-type?
	setAttribute(sessionMgr, RuntimeTagNames.PERSISTENCE_TYPE, (String) descriptor.getAttributeValue(SessionManager.PERSISTENCE_TYPE));
	
	return sessionMgr;
    }
	
}
