/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.node.runtime;

import java.util.*;
import org.w3c.dom.Node;
import java.util.logging.Level;

import javax.xml.namespace.QName;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.node.runtime.web.WebBundleRuntimeNode;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.xml.WebServicesTagNames;

import java.net.URL;
import java.net.MalformedURLException;

import com.sun.enterprise.deployment.util.DOLUtils;

/**
 * This node is responsible for handling WebService runtime info 
 *
 * @author  Kenneth Saks
 * @version 
 */
public class WebServiceRuntimeNode extends DeploymentDescriptorNode {

    private WebService descriptor;

    public Object getDescriptor() {
        return descriptor;
    }

    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */

    public void setElementValue(XMLElement element, String value) {
        if (WebServicesTagNames.WEB_SERVICE_DESCRIPTION_NAME.equals
            (element.getQName())) {
            BundleDescriptor parent;
            if (getParentNode() instanceof WebBundleRuntimeNode) {
                parent = ((WebBundleRuntimeNode) getParentNode()).getWebBundleDescriptor();
            } else {
                parent = (BundleDescriptor) getParentNode().getDescriptor();
            }
            WebServicesDescriptor webServices = parent.getWebServices();
            descriptor = webServices.getWebServiceByName(value);
        } else if( WebServicesTagNames.CLIENT_WSDL_PUBLISH_URL.equals
                   (element.getQName()) ) {
            if( descriptor == null ) {
                DOLUtils.getDefaultLogger().info
                    ("Warning : WebService descriptor is null for "
                     + "final wsdl url=" + value);
                return;
            }
            try {
                URL url = new URL(value);
                descriptor.setClientPublishUrl(url);
            } catch(MalformedURLException mue) {
                DOLUtils.getDefaultLogger().log(Level.INFO,
                  "Warning : Invalid final wsdl url=" + value, mue);
            }
        } else {
            super.setElementValue(element, value);
        }
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, 
                                WebService webService) {
        Node webServiceNode = 
            super.writeDescriptor(parent, nodeName, webService);

        appendTextChild(webServiceNode, 
                        WebServicesTagNames.WEB_SERVICE_DESCRIPTION_NAME,
                        webService.getName());

        if( webService.hasClientPublishUrl() ) {
            URL url = webService.getClientPublishUrl();
            appendTextChild(webServiceNode, 
                            WebServicesTagNames.CLIENT_WSDL_PUBLISH_URL,
                            url.toExternalForm());
        }

        return webServiceNode;
    }  
    
    /**
     * writes all the runtime information for the web services for a given
     * bundle descriptor
     * 
     * @param parent node to add the runtime xml info
     * @param the bundle descriptor
     */        
    public void writeWebServiceRuntimeInfo(Node parent,
                                           BundleDescriptor bundle) {
        WebServicesDescriptor webServices = bundle.getWebServices();
        if( webServices != null ) {
            for(Iterator iter = webServices.getWebServices().iterator(); 
                iter.hasNext();) {
                WebService next = (WebService) iter.next();
                if( next.hasClientPublishUrl() ) {
                    writeDescriptor
                        (parent, WebServicesTagNames.WEB_SERVICE, next);
                }
            }
        }
    }
    
}
