/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime;

import org.w3c.dom.Node;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.ResourcePrincipal;

/**
 * This node handles the runtime deployment descriptor tag 
 * default-resource-principal
 *
 * @author  Jerome Dochez
 * @version 
 */
public class DefaultResourcePrincipalNode extends DeploymentDescriptorNode {

    private String name = null;
    private String passwd = null;

   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        return null;
    }
    
    /**
     * receives notification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */
    public void setElementValue(XMLElement element, String value) {
        if (RuntimeTagNames.NAME.equals(element.getQName())) {
            name = value;
        } else  if (RuntimeTagNames.PASSWORD.equals(element.getQName())) {
            passwd = value;
        } else super.setElementValue(element, value);
    }
    
    /**
     * notification of the end of XML parsing for this node
     */
    public void postParsing() {   
        if (getParentNode().getDescriptor() instanceof ResourceReferenceDescriptor) {
            ((ResourceReferenceDescriptor) getParentNode().getDescriptor()).setResourcePrincipal(new ResourcePrincipal(name, passwd));
        } else {
            getParentNode().addDescriptor(new ResourcePrincipal(name, passwd));
        }
    }

    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name for the descriptor
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, ResourcePrincipal rpDescriptor) {     
        Node principalNode = super.writeDescriptor(parent, nodeName, null);
        appendTextChild(principalNode, RuntimeTagNames.NAME, rpDescriptor.getName());
	appendTextChild(principalNode, RuntimeTagNames.PASSWORD, rpDescriptor.getPassword()); 
        return principalNode;
    }    
}
