/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node;


import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import org.w3c.dom.Node;
import org.w3c.dom.Element;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.xml.TagNames;


/**
 * This node class is responsible for handling all the information 
 * related to displayable elements like display-name or icons.
 * 
 * @author  Jerome Dochez
 * @version 
 */
public abstract class DisplayableComponentNode extends DeploymentDescriptorNode {

    public DisplayableComponentNode() {
        super();
        registerElementHandler(new XMLElement(TagNames.NAME), LocalizedInfoNode.class);       
        registerElementHandler(new XMLElement(TagNames.ICON), IconNode.class);           
        registerElementHandler(new XMLElement(TagNames.SMALL_ICON), IconNode.class);           
        registerElementHandler(new XMLElement(TagNames.LARGE_ICON), IconNode.class);           
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, Descriptor descriptor) {
        Node node = super.writeDescriptor(parent, descriptor);        
        
        // description, display-name, icons...
        writeDisplayableComponentInfo(node, descriptor);
        return node;
    } 
    
    /**
     * write the localized descriptions, display-names and icons info
     *
     * @param the node to write the info to
     * @param the descriptor containing the displayable information
     */
    protected void writeDisplayableComponentInfo(Node node, Descriptor descriptor) {
        LocalizedNode localizedNode = new LocalizedNode();
        localizedNode.writeLocalizedMap(node, TagNames.DESCRIPTION, descriptor.getLocalizedDescriptions());
        localizedNode.writeLocalizedMap(node, TagNames.NAME, descriptor.getLocalizedDisplayNames());
        IconNode iconNode = new IconNode();
        iconNode.writeLocalizedInfo(node, descriptor);
        
    }       
}
