/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.introspection;

import java.nio.channels.ReadableByteChannel;
import java.nio.ByteBuffer;
import java.io.IOException;

import java.util.Set;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

import com.sun.enterprise.deployment.annotation.factory.SJSASFactory;


/**
 * This class contains the list of all annotations types name 
 * which can be present at the class level (Type.TYPE).  
 *
 * @author Jerome Dochez
 */
public class AnnotationScanner {

    private static Set<String> annotations=null;
    
    /** Creates a new instance of AnnotationScanner */
    private AnnotationScanner() {
    }
        
    /**
     * Test if the passed constant pool string is a reference to 
     * a Type.TYPE annotation of a J2EE component
     *
     * @String the constant pool info string 
     * @return true if it is a J2EE annotation reference
     */
    public static boolean isAnnotation(String value) {
        if (annotations==null) {
            synchronized(AnnotationScanner.class) {
                if (annotations==null)
                   init();
            }
        }
        return annotations.contains(value);
    }
    
    private static void init() {
        annotations = SJSASFactory.getAnnotations();
    }
}
