/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.io.Serializable;

/** 
 * This descriptor represent the information about a tag library used in a 
 * web application.
 *
 * @author Danny Coward
 */

public class TagLibConfigurationDescriptor implements Serializable {
    private String uri; 
    private String location;
    
    /** 
     * Default constructor.
     */
    public TagLibConfigurationDescriptor() {
    }
    
    /** 
     * Construct a tag library configuration with the given location and URI.
     * @param the URI.
     * @param the location.
     */
    public TagLibConfigurationDescriptor(String uri, String location) {
	this.uri = uri;
	this.location = location;
    }
    
    /**
     * Sets the URI of this tag lib.
     * @param the URI of the tag library.
     */
    public void setTagLibURI(String uri) {
        this.uri = uri;
    }
    
    /**
     * Return the URI of this tag lib.
     * @return the URI of the tag library.
     */
    public String getTagLibURI() {
	if (this.uri == null) {
	    this.uri = "";
	}
	return this.uri;
    }
    
    /**
     * Describe the location of the tag library file.
     * @param the location of the tag library.
     */
    public void setTagLibLocation(String location) {
        this.location = location;
    }
    
    /**
     * Describes the location of the tag library file.
     * @return the location of the tag library.
     */
    public String getTagLibLocation() {
	if (this.location == null) {
	    this.location = "";
	}
	return this.location;
    }
    
    /** 
     * Return a formatted String representing my state.
     */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("TGLIB: ").append(uri).append(", ").append(location);
    }
    
}
