/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.io.*;
import java.util.*;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.web.InitializationParameter;
import com.sun.enterprise.deployment.web.ServletFilter;
import com.sun.enterprise.deployment.web.ServletFilterMapping;

/**
 * Deployment object representing the servlet filter spec
 * @author Martin D. Flynn
 */
public class ServletFilterDescriptor
    extends Descriptor
    implements ServletFilter
{

    /** class name */
    private String className = "";

    /** display name */
    private String displayName = "";

    /** filter name */
    private String filterName = "";

    /** initialization parameters */
    private Vector initParms = new Vector();

    /* ----
    */

    /** generic constructor */
    public ServletFilterDescriptor() {
	super("", ""/*description*/);
	this.setClassName("");
    }

    /** constructor specifying descriptor name (Filter name) & displayName */
    public ServletFilterDescriptor(String className, String name) {
	super(name, ""/*description*/);
	this.setClassName(className);
    }

    /* ----
    */

    /** set class name */
    public void setClassName(String name) {
	this.className = (name != null)? name : "";
    }

    /** get class name */
    public String getClassName() {
	if (this.className == null) {
	    this.className = "";
	}
	return this.className;
    }

    /** set display name */
    public void setDisplayName(String name) {
	this.displayName = (name != null)? name : "";
    }

    /** get display name */
    public String getDisplayName() {
	String n = this.displayName;
	if ((n == null) || n.equals("")) {
	    n = this.getName();
	}
	return n;
    }

    /** set filter name */
    public void setName(String filterName) {
        this.filterName = filterName;
    }

    /** get filter name */
    public String getName() {
	if ((filterName == null) || filterName.equals("")) {
	    String c = this.getClassName();
	    int p = c.lastIndexOf('.');
	    filterName = (p < 0)? c : c.substring(p + 1);
	}
	return filterName;
    }

    /* ----
    */

    /* set initialization parameters */
    public void setInitializationParameters(Collection c) {
	this.initParms.clear();
	this.initParms.addAll(c);
    }

    /* get initialization parameters */
    public Vector getInitializationParameters() {
	return (Vector)this.initParms.clone();
    }

    /* add a single initialization parameter */
    public void addInitializationParameter(InitializationParameter ref) {
	this.initParms.addElement(ref);
    }
    
    /* add a single initialization parameter */
    public void addInitializationParameter(EnvironmentProperty ref) {
	addInitializationParameter((InitializationParameter) ref);
    }    

    /* remove a single initialization parameter */
    public void removeInitializationParameter(InitializationParameter ref) {
	this.initParms.removeElement(ref);
    }

    /* ----
    */

    /** compare equals */
    public boolean equals(Object obj) {
        /*
	return (obj instanceof ServletFilter)?
	    this.getClassName().equals(((ServletFilter)obj).getClassName()) :
	    super.equals(obj);
        */

        //Should allow a filter with different name mapping
        //to the same class.
        if (obj instanceof ServletFilter) {
	    if (this.getClassName().equals(
                        ((ServletFilter)obj).getClassName())
                    && this.getName().equals(
                            ((ServletFilter)obj).getName())) {
                return true;
            }
        }

        return false;
    }
}
