/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.Role;
import com.sun.enterprise.deployment.web.SecurityRoleReference;
import com.sun.enterprise.deployment.web.SecurityRole;

/** 
 * Special kind of environment property that encapsulates the primitive roles 
 * as defined by the bean developer. The name of a primitive role will appear 
 * in the bean code, the value will be mapped to the name of a Role chosen by 
 * the application assembler which is referenced by the EjbBundle being 
 * assembled.
 * @author Danny Coward
 */

public class RoleReference extends EnvironmentProperty implements 
		SecurityRoleReference 
{
    /** 
     * Default constructor.
     */
    public RoleReference() {
    }

    /** 
     * Construct a role reference from the given name and description.
     */
    public RoleReference(String name, String description) {
	super(name, "", description);
    }
    
    /** 
     * Construct the role reference with the same name and rolename the same 
     * as the environment property value.
     * @param the environment property instance.
     */
    public RoleReference(EnvironmentProperty environmentProperty) {
	super(environmentProperty.getName(), 
		environmentProperty.getDescription(), "");
	this.setValue(environmentProperty.getValue());
    }
    
    /**
     * Set the value for the reference.
     * @param the role
     */
    void setRole(Role role) {
	super.setValue(role.getName());
    }
    
    /** 
     * Return the role object from this descriptor.
     * @return the role.
     */
    public Role getRole() {
	return new Role(super.getValue());
    }
    
    /** 
     * Return the rolename.
     * @return the role name.
     */
    public SecurityRole getSecurityRoleLink() {
	return new SecurityRoleDescriptor(super.getValue(), "");
    }
    
    /** 
     * Sets the rolename.
     * @param the rolename.
     */
    public void setSecurityRoleLink(SecurityRole securityRole) {
	super.setValue(securityRole.getName());
    }
    
    /** 
     * Return the coded name. 
     * @return the role name used in the bean code.
     */
    public String getRolename() {
	return this.getName();
    }
    
    /** 
     * Sets the coded name.
     * @param the role name used in the bean code.
     */
    public void setRolename(String rolename) {
	this.setName(rolename);
    }
    
    /**
     * Returns a formatted version of this object as a String.
     */
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("Role-Ref-Env-Prop: ").append(super.getName()).append("@").append( 
	    this.getRole()).append("@").append(super.getDescription());
    }

}

