/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

/** 
 * This class represents information about a web service
 * endpoint.
 *
 * @author Kenneth Saks
 */

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;

import com.sun.enterprise.deployment.types.MessageDestinationReferencer;

public class MessageDestinationDescriptor extends Descriptor implements NamedDescriptor{

    private String msgDestName;

    // JNDI name of physical destination to which this logical
    // destination is mapped.
    private String jndiName;
    private String mappedName;

    // Set of MessageDestinationReferencer descriptors pointing to me.
    private Set referencers = new HashSet();

    // bundle in which I am defined
    private BundleDescriptor bundleDescriptor;

    public MessageDestinationDescriptor() {
    }

    public MessageDestinationDescriptor(String name, String description) {
        super("", description);
        msgDestName = name;
    }

    public boolean hasName() {
        return (msgDestName != null);
    }

    public void setName(String name) {
        msgDestName = name;
    }

    public String getName() {
        return msgDestName;
    }

    public void setDisplayName(String displayName) {
        setLocalizedDisplayName(null, displayName);
    }

    public String getDisplayName() {
        return getLocalizedDisplayName(null);
    }

    public Set getAllReferencers() {
        return referencers;
    }

    public void addReferencer(MessageDestinationReferencer referencer) {
        referencers.add(referencer);
    }

    public void removeReferencer(MessageDestinationReferencer referencer) {
        referencers.remove(referencer);
    }

    public BundleDescriptor getBundleDescriptor() {
        return bundleDescriptor;
    }

    public void setBundleDescriptor(BundleDescriptor bundleDesc) {
        if( bundleDesc == null ) {
            for(Iterator iter = referencers.iterator(); iter.hasNext();) {
                MessageDestinationReferencer next =
                    (MessageDestinationReferencer) iter.next();
                next.setMessageDestination(null);
            }
            referencers.clear();
        }
        bundleDescriptor = bundleDesc;
    }

    public String getJndiName() {
        return (jndiName != null) ? jndiName : mappedName;
    }

    public void setJndiName(String physicalDestinationName) {
        jndiName = physicalDestinationName;
    }

    public String getMappedName() {
        return mappedName;
    }

    public void getMappedName(String mappedName) {
        this.mappedName = mappedName;
    }
}
