/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.addon;

import java.io.*;
import java.util.*;

/**
 * This class maintains the registry, it is a warpper over Properties class.
 * @author servesh.singh@sun.com
 */
public class Registry {
    
    /** Creates a new instance of Registry */
    private Properties registry = null;
    FileOutputStream out = null;
    FileInputStream in = null;
    File registryFile = null; 
    
    public Registry() {
    }
    
    public void load(File registryFile) throws Exception {
        this.registryFile = registryFile;
        if(!registryFile.exists()) {
            registryFile.createNewFile();
        }
        in = new FileInputStream(registryFile);
        registry = new Properties();
        registry.load(in);
    }
    
    public String getProperty(String key) throws Exception{
         return registry.getProperty(key);
    }
    
    public void setProperty(String key, String value) throws Exception{
        registry.setProperty(key, value);
    }
    
    public void store() throws Exception{
        out = new FileOutputStream(registryFile);
        registry.store(out, null);  
        out.close();
    }
    
    public void close() throws Exception {
        if(in != null)
            in.close();
    }
    
}
