/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.filter.spi;

/**
 * Filter that can implement or collect web services management information 
 */
public interface Filter {

    /**
     * Invoke the filter.
     *
     * @param stage     Stage of the web service endpoint's execution
     * @param endpoint  Endpoint's name
     * @param context   FilterContext containing information about message
     */
    public void process(String stage, String endpoint, FilterContext context); 

    /**
     * Unique name of the filter
     *
     * @return Unique name of the filter.
     */
    public String getName();

    /** 
     * Post process response - Callback when a web service response has finished
     * being processed by the container and was sent back to the client
     */
    public static final String POST_PROCESS_RESPONSE = "POST_PROCESS_RESPONSE";

    /**
     * Callback when a web service request entered the web service container and
     * before any system processing is done.
     */
    public static final String PRE_PROCESS_REQUEST = "PRE_PROCESS_REQUEST";


    /**
     * Callback when a web service request is about to be delivered to the Web
     * Service Implementation Bean.
     */
    public static final String PROCESS_REQUEST = "PROCESS_REQUEST";

    /**
     * Callback when a web service response was returned by the Web Service
     * Implementation Bean 
     */
    public static final String PROCESS_RESPONSE = "PROCESS_RESPONSE";
}
