/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import java.util.Locale;
import java.util.Map;

import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.PropertyHelper;
import com.sun.enterprise.config.serverbeans.validation.Result;

import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.ElementProperty;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;


import java.util.logging.Level;

/**
    Custom Test for Jdbc Connection Pool Test which calls the Generic Validation before performing custom tests

    @author Srinivas Krishnan
    @version 2.0
*/

public class JdbcConnectionPoolTest extends GenericValidator {
    
    static boolean checked = false;
    int maxPoolSize = 0;
    
    public JdbcConnectionPoolTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    public void validate(ValidationContext valCtx) {
        super.validate(valCtx); // Before doing custom validation do basic validation
        
        if(valCtx.isVALIDATE() || valCtx.isADD() || valCtx.isSET())
        {
            JdbcConnectionPool pool = (JdbcConnectionPool)valCtx.getTargetBean();
            if(pool.isIsConnectionValidationRequired() && pool.getConnectionValidationMethod().equals("table")) {
                if(pool.getValidationTableName() == null || pool.getValidationTableName().equals(""))
                    reportValidationError(valCtx, "requiredTableName", 
                    "Table Name is required Jdbc Connection Pool if Connection validation method is Table",
                    null);
            }
            checkLazyConnectionProps(valCtx);
        }
    }
    
    //property changes reaction
    static final String LAZY_CONN_ASSOCIATION = "LazyConnectionAssociation";
    static final String LAZY_CONN_ENLISTMENT = "LazyConnectionEnlistment";
    
    public void validatePropertyChanges(ValidationContext propValCtx) 
    {
        
        if(propValCtx.isDELETE() || propValCtx.isVALIDATE()) //no validation
            return;
        
        if(!PropertyHelper.isPropertyChanged(propValCtx, LAZY_CONN_ASSOCIATION) &&
           !PropertyHelper.isPropertyChanged(propValCtx, LAZY_CONN_ENLISTMENT))
            return;
        
        //here we are only if some changes with testing props occured
        checkLazyConnectionProps(propValCtx);
    }
    
    private void checkLazyConnectionProps(ValidationContext valCtx)
    {
        Map map;
        ConfigBean targetBean = valCtx.getTargetBean();
        if(targetBean==null)
            return;
        if(targetBean instanceof ElementProperty)
            map = PropertyHelper.getFuturePropertiesMap(valCtx);
        else
            map = PropertyHelper.getPropertiesMap(targetBean);
        String newAsso = (String)map.get(LAZY_CONN_ASSOCIATION);
        String newEnlist = (String)map.get(LAZY_CONN_ENLISTMENT);
        if(newAsso!=null &&  newEnlist!=null &&
           Boolean.parseBoolean(newAsso) && !Boolean.parseBoolean(newEnlist))
        {
            reportValidationError(valCtx, "PropsConflict", 
                "Combination of properties {0}={1} and {2}={3} is not allowed.",
                new Object[]{LAZY_CONN_ASSOCIATION, newAsso,
                             LAZY_CONN_ENLISTMENT, newEnlist});
        }
    }
}
