/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import java.util.logging.Level;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.GenericValidator;

/**
   Instances of this class represent applications taht can be
   deployed. They provide a deeper validation by supplying the ability
   to validate their object type attribute - updates and deletions are
   only allowed if this attribute has the value 'user'
 */
abstract class DeployableAppTest extends GenericValidator
{

    DeployableAppTest(final ValidationDescriptor desc){
        super(desc);
    }

    public Result validate(ConfigContextEvent cce) {
        Result result = super.validate(cce); // Before doing custom
                                             // validation do basic
                                             // validation
        try{
            if(cce.getChoice().equals(StaticTest.UPDATE) || cce.getChoice().equals(StaticTest.DELETE)) { 
            
                if(!getObjectType(cce).equals("user"))
                    result.failed(smh.getLocalString(getClass().getName()+".systemAppNotChangeable",
                                                     "System Application, Attribute Not Changeable"));
            }
        }
        catch (final ConfigException ce){
            _logger.log(Level.WARNING, "domainxmlverifier.exception", ce);
        }
        return result;
    }

        /**
           Return the object type given the config bean of the
           deployable app.
           @param app the application whose object type we want
           @return the value of the object-type attribute
        */
    protected abstract String getObjectType(final ConfigBean app);
    
        /**
           Return the object type from the receiver's class object.
         */
        // Implementor's note - this is only valid for operations
        // other than SET - if the operation is a SET operation then
        // the value object can be an array of config beans, and this
        // isn't implemented.
    private String getObjectType(final ConfigContextEvent cce) throws ConfigException{
        return getObjectType(getApp(cce));
    }

    private ConfigBean getApp(final ConfigContextEvent cce)  throws ConfigException{
        return (ConfigBean) cce.getValidationTarget();
    }

        
}


        
