/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import java.io.File;

/**
    Class which contains Meta data for all types of attributes which is present in Validation Descriptor
 *  XML File
 *
 *  Sample
 *      <attribute name=<Name> type="address" />
 *      <attribute name=<Name> type="integer" range="low,high" />
 *      <attribute name=<Name> type="string"  max-length="length" />
    
    @author Srinivas Krishnan
    @version 2.0
*/

/* Class for attribute type file */

public class AttrFile extends AttrType {
    
    boolean checkExists;
    
    public AttrFile(String name, String type, boolean optional) {
        super(name,type, optional);
        checkExists = false;
    }
    
    public void setCheckExists(boolean flag) {
        checkExists = flag;
    }
    
    public void validate(Object o, ValidationContext valCtx) {
        super.validate(o, valCtx); // call to common validator first
	if(o == null || o.equals(""))
		return;
        if(checkExists || StaticTest.fileCheck) {
            File f = new File((String)o);
            if(!f.exists()) 
               valCtx.result.failed(valCtx.smh.getLocalString(getClass().getName() + ".fileNotExists",
                                            "Attribute({0}={1}) : {2} : Does not exists", new Object[] {valCtx.attrName, o, o}));
            else if(!f.canRead()) 
               valCtx.result.failed(valCtx.smh.getLocalString(getClass().getName() + ".filecannotRead",
                                            "Attribute({0}={1}) : {2} : Does not have read permission", new Object[] {valCtx.attrName, o, o}));
        }                                        
    }
}
