/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt;

import javax.xml.parsers.*;
import org.xml.sax.*;
import java.io.ByteArrayInputStream;

import javax.management.ObjectName;

import com.sun.enterprise.util.i18n.StringManager;

/**
 * Validates the repository name. A repository name must be a
 * - valid file name, 
 * - valid xml CDATA value &
 * - valid javax.management.ObjectName property value.
 */
public class RepositoryNameValidator extends StringValidator
{
    private static final String VALID_CHAR = 
        "[^\\,\\/ \\&\\;\\`\\'\\\\\"\\|\\*\\!\\?\\~\\<\\>\\^\\(\\)\\[\\]\\{\\}\\$\\:\\%]*";

    private static final String IAS_NAME = "com.sun.appserv:name=";

    private static final String XML_1 = 
        "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <xml>";

    private static final String XML_2 = "</xml>";

    /**
     * i18n strings manager object
     */
    private static final StringManager strMgr = 
        StringManager.getManager(RepositoryNameValidator.class);

    /**
     * Constructs new RepositoryNameValidator object.
     * @param name
     */
    public RepositoryNameValidator(String name)
    {
        super(name);
    }

    /**
     * Validates the given value for the given entry. This method first invokes
     * its superclass's validate method and then performs additional validations.
     * @throws InvalidConfigException
     */
    public void validate(Object str) throws InvalidConfigException
    {
        super.validate(str);
        checkValidName((String)str);
        checkValidXmlToken((String)str);
        checkValidObjectNameToken((String)str);
    }

    public void checkValidName(String name) throws InvalidConfigException
    {
        if (!name.matches(VALID_CHAR))
        {
            throw new InvalidConfigException(
                strMgr.getString("validator.invalid_value", getName(), name));
        }
    }

    /**
     * Implementation copied from 
     * com.sun.enterprise.admin.verifier.tests.StaticTest
     */
    public void checkValidXmlToken(String name) throws InvalidConfigException
    {
        try
        {
            //Construct a valid xml string
            String xml = XML_1 + name + XML_2;
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            InputSource is = new InputSource(bais);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.parse(is);
        }
        catch (Exception e)
        {
            throw new InvalidConfigException(
                strMgr.getString("validator.invalid_value", getName(), name));
        }
    }

    public void checkValidObjectNameToken(String name) 
        throws InvalidConfigException
    {
        try
        {
            new ObjectName(IAS_NAME + name);
        }
        catch (Exception e)
        {
            throw new InvalidConfigException(
                strMgr.getString("validator.invalid_value", getName(), name));
        }
    }
}
