/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.pluggable;

import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.diagnostics.DiagnosticAgent;
/**
 * The interface to provide access to supported Pluggable Features implemented 
 * purely on the client side (asadmin). The server side equivalent of this 
 * class is com.sun.enterprise.server.pluggable.PluggableFeatureFactors
 * and is not available to asadmin.
 * 
 * Various editions of the product may provide varied implementation for
 * same feature. This interface has different implementation for every
 * product edition. Every method in this interface provides access to
 * implementation of a pluggable feature. The pattern for this class is
 * to define getter methods for every pluggable feature, where a pluggable
 * feature is a java interface.
 */
public interface ClientPluggableFeatureFactory {

    /**
     * Name of the property used to define pluggable features list.
     */
    public static final String PLUGGABLE_FEATURES_PROPERTY_NAME =
            "com.sun.appserv.admin.pluggable.features";

    /**
     * Get access to the DomainsManager which is used to create a 
     * domain from templates.
     */
    public DomainsManager getDomainsManager();
    
    public DiagnosticAgent getDiagnosticAgent();
}
