/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MethodStartAccessObjectImpl.java
 *
 * Created on July 14, 2005, 1:56 PM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import com.sun.enterprise.admin.common.constant.AdminConstants;
/**
 *
 * @author Harpreet Singh
 */
public class MethodStartAccessObjectImpl extends AbstractTableAccessObject{
    private static final Logger logger =
            Logger.getLogger(AdminConstants.kLoggerName);

    private static MethodStartAccessObjectImpl _singletonMS;
    
    /** Creates a new instance of MethodStartAccessObjectImpl */
    private MethodStartAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        super.tableName = TableInfo.METHOD_START_TABLE_NAME +
                serverName.toUpperCase();
    }

    public boolean createTable(Connection connection) {
        super.con = connection;        
        return super.createTable(
                TableInfo.CREATE_TABLE_METHOD_START_SQL, 
                TableInfo.METHOD_START_TABLE_NAME);
    }

    public boolean dropTable(Connection connection) {
        super.con = connection;        
        return super.createStatmentAndExecuteUpdate(    
                TableInfo.DROP_TABLE_METHOD_START_SQL, 
                TableInfo.METHOD_START_TABLE_NAME);
    }
   
    public static TableAccessObject getInstance() {
        if(_singletonMS == null)
            _singletonMS = new MethodStartAccessObjectImpl ();
        
        return _singletonMS;
    }

    public boolean insert(java.sql.PreparedStatement pstmt, TransferObject[] transferObject) {
      // sanity
        if (pstmt == null)
            return false;
        boolean result = false;
        try{
            
            for (int i = 0 ; i<transferObject.length; i++) {
                MethodStartTO methodStartTO = (MethodStartTO)transferObject[i];
                pstmt.setString(1, methodStartTO.getRequestId());
                pstmt.setLong(2, methodStartTO.getTimeStamp());
                
                if (methodStartTO.getComponentType() != null)
                    pstmt.setString(3, methodStartTO.getComponentType().toString());
                else
                    pstmt.setString(3, null);

                pstmt.setString(4, methodStartTO.getComponentName());
                pstmt.setString(5, methodStartTO.getAppName());
                pstmt.setString(6, methodStartTO.getMethodName());

                pstmt.setString(7, methodStartTO.getModuleName());
                pstmt.setString(8, methodStartTO.getThreadId());
                pstmt.setString(9, methodStartTO.getTransactionId());

                pstmt.setString(10, methodStartTO.getSecurityId());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result =  (updated.length == transferObject.length)? true : false;
        }  catch(BatchUpdateException bue) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }catch (SQLException se) {
            // log it
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;    }

      public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(
                TableInfo.INSERT_INTO_TABLE_METHOD_START_SQL, 
                TableInfo.METHOD_START_TABLE_NAME);
        return newsql;        
    }

      public String getDeleteSQL () {
        String newsql = super.updateSqlWithTableName (
                TableInfo.DELETE_FROM_TABLE_METHOD_START_SQL,
                TableInfo.METHOD_START_TABLE_NAME);
        return newsql;
    }
      
}
