/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/tests/com/sun/enterprise/admin/dottedname/DottedNameTestsMain.java,v 1.3 2005/12/25 03:43:07 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:43:07 $
 */
 
package com.sun.enterprise.admin.dottedname;

import java.util.Iterator;
import java.util.Arrays;

import junit.extensions.ActiveTestSuite;
import junit.framework.TestSuite;

public class DottedNameTestsMain
{
	
	public static final Class [] TEST_CLASSES = 
	{
		com.sun.enterprise.admin.util.TokenizerTest.class,
		DottedNameTest.class,
		DottedNameFactoryTest.class,
		DottedNameRegistryTest.class,
		DottedNameGetSetMBeanImplTest.class,
	};
	
		static void
	testClass( Class theClass )
	{
		System.out.println( "*** testing " + theClass.getName() + " ***");
		// use 'ActiveTestSuite' to thread the tests
		final TestSuite	suite	= new ActiveTestSuite( theClass );
		junit.textui.TestRunner.run( suite );
	}
	
		public static void
	main( String [] args )
	{
		final Iterator iter	= Arrays.asList( TEST_CLASSES ).iterator();
		
		while ( iter.hasNext() )
		{
			final Class	theClass	= (Class)iter.next();
			
			testClass( theClass );
		}
	}
}


