/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/valueaccessor/AnyValueAccessor.java,v 1.3 2005/12/25 03:42:06 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:06 $
 */
 

package com.sun.enterprise.admin.dottedname.valueaccessor;


import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.Attribute;


import com.sun.enterprise.admin.dottedname.valueaccessor.PrefixedValueSupport;
import com.sun.enterprise.admin.dottedname.valueaccessor.PropertyValueAccessorBase;

/*
	Encapsulates all accessors so that caller need not distinguish between them.
 */
public class AnyValueAccessor extends ValueAccessorBase
{
	final ValueAccessor				mAttributeAccessor;
	
	
		public
	AnyValueAccessor( MBeanServerConnection conn )
	{
		super( conn );
		
		mAttributeAccessor	= new AttributeValueAccessor( conn );
	}
	
		public Attribute
	getValue( ObjectName objectName, String valueName ) throws Exception
	{
		Attribute	attr	= null;
		PropertyValueAccessorBase propertyAccessor= 
                 (new PrefixedValueSupport(getMBS()).getPrefixedValueAccessor(valueName));
		if ( propertyAccessor!=null )
		{
			attr	= propertyAccessor.getValue( objectName, 
                      propertyAccessor.extractPrefixedValueName(valueName) );
		}
		else
		{
			attr	= mAttributeAccessor.getValue( objectName, valueName );
		}
		
		return( attr );
	}
	
		public Attribute
	setValue( ObjectName objectName, Attribute attr ) throws Exception
	{
		Attribute	resultAttr	= null;
		
		final String	valueName	= attr.getName();
		PropertyValueAccessorBase propertyAccessor= 
                 (new PrefixedValueSupport(getMBS()).getPrefixedValueAccessor(valueName));
        if ( propertyAccessor!=null )
		{
			final String	propertyName = propertyAccessor.extractPrefixedValueName(valueName);
			final Attribute	newAttr	= new Attribute( propertyName, attr.getValue() );
			resultAttr	= propertyAccessor.setValue( objectName, newAttr );
		}
		else
		{
			resultAttr	= mAttributeAccessor.setValue( objectName, attr );
		}
		
		return( resultAttr );
	}
}



