/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.j2ee;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.Iterator;
import java.util.Map;

import javax.management.ObjectName;
import javax.management.InstanceNotFoundException;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.j2ee.WebServiceEndpoint;
import com.sun.appserv.management.j2ee.J2EETypes;
import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.appserv.management.ext.wsmgmt.MessageTraceImpl;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;


/**
 */
public final class WSMsgTraceTest extends AMXTestBase
{
		public
	WSMsgTraceTest( )
		throws IOException
	{
	}
	
		public void
	testMessageTrace()
		throws ClassNotFoundException
	{
		final Set<WebServiceEndpoint> s	=
		    getQueryMgr().queryJ2EETypeSet(J2EETypes.WEB_SERVICE_ENDPOINT);
		
        for( final WebServiceEndpoint wsp : s )
        {
            MessageTrace[] msgs = wsp.getMessagesInHistory();
            if ( msgs == null) {
                System.out.println(" No messages collected " );
                return;
            }
            System.out.println(" Collected messages  " + msgs.length);
            for ( int idx =0; idx < msgs.length; idx++) {
                final MessageTrace msg = msgs[idx];

                System.out.println(" message id  " + msg.getMessageID());
                System.out.println(" application id " + msg.getApplicationID());
                System.out.println(" endpoint name " + msg.getEndpointName());
                System.out.println(" response size " + msg.getResponseSize());
                System.out.println(" request size " + msg.getRequestSize());
                System.out.println(" transport type is " +
                    msg.getTransportType());
                System.out.println(" request headers are " +
                    msg.getHTTPRequestHeaders() );
                System.out.println(" response headers are " +
                    msg.getHTTPResponseHeaders() );
                System.out.println(" fault code is  " + msg.getFaultCode());
                System.out.println(" fault string is  " + msg.getFaultString());
                System.out.println(" fault actor is " + msg.getFaultActor());
                System.out.println(" client host is  " + msg.getClientHost());
                System.out.println(" principal name is " + 
                    msg.getPrincipalName());
            }
        }
	}


}


