/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.io.IOException;
import java.util.Set;
import java.util.Iterator;
import java.util.Map;

import javax.management.Attribute;


import com.sun.appserv.management.base.DottedNames;
import com.sun.appserv.management.config.ConfigDottedNames;
import com.sun.appserv.management.monitor.MonitoringDottedNames;
import com.sun.appserv.management.util.stringifier.SmartStringifier;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class DottedNamesTest extends AMXTestBase
{
		public
	DottedNamesTest( )
	{
	}
	
		private void
	checkAttribute( final Attribute attr )
	{
		assert( attr != null );
		
		final Object value	= attr.getValue();
		if ( value instanceof Attribute )
		{
			warning( "Is value of " + attr.getName() + " really another Attribute? => " +
				toString( value ) );
		}
	}
	
		private void
	checkResultsFromWildGet(
		final Object[] results )
	{
		for( int i = 0; i < results.length; ++i )
		{
			final Object	result	= results[ i ];
			
			if ( result == null )
			{
				warning( "null result from dottedNameGet( \"*\" )" );
			}
			else if ( ! (result instanceof Attribute) )
			{
				warning( "non-Attribute result from dottedNameGet( \"*\" ): " + result );
			}
			else
			{
				// it's an Attribute
				final Attribute attr	= (Attribute)result;
				checkAttribute( (Attribute)result );
			}
		}
	}
	
		private void
	checkResultsFromGet(
		final String[]	names,
		final Object[]	results )
	{
		for( int i = 0; i < results.length; ++i )
		{
			final Object	result	= results[ i ];
			
			if ( result == null )
			{
				warning( "Dotted name has null result: " + names[ i ] );
			}
			else if ( ! (result instanceof Attribute) )
			{
				warning( "Dotted name " + names[ i ] + " could not be obtained: " + result );
			}
		}
	}
		
		private String[]
	getAllNames( final DottedNames dottedNames )
	{
		final Attribute[] attrs	= (Attribute[])dottedNames.dottedNameGet( "*" );
		final String[]	names	= new String[ attrs.length ];
		for( int i = 0; i < names.length; ++i )
		{
			names[ i ]	= attrs[ i ].getName();
		}
		
		return( names );
	}
	
	
		public void
	testGetAllConfigDottedNames()
	{
		final long	start	= now();
		final ConfigDottedNames	dottedNames	= getDomainRoot().getConfigDottedNames();
		
		final String[]	names	= getAllNames( dottedNames );
		
		final Object[] results	= dottedNames.dottedNameGet( names );
		
		checkResultsFromGet( names, results );
		printElapsed( "testGetAllConfigDottedNames", start );
	}
	
		public void
	testGetAllMonitoringDottedNames()
	{
		if ( checkNotOffline( "testMonitoringRefresh" ) )
		{
		    final MonitoringDottedNames	dottedNames	= getDomainRoot().getMonitoringDottedNames();
    		final long	start	= now();
    		final String[]	names	= getAllNames( dottedNames );
    		
    		final Object[] results	= dottedNames.dottedNameGet( names );
    		
    		checkResultsFromGet( names, results );
    		printElapsed( "testGetAllMonitoringDottedNames", start );
		}
	}
	
		public void
	testWildGetAllConfigDottedNames()
	{
		final long	start	= now();
		final ConfigDottedNames	dottedNames	= getDomainRoot().getConfigDottedNames();
		
		final Attribute[] results	= (Attribute[])dottedNames.dottedNameGet( "*" );
		checkResultsFromWildGet( results );
		printElapsed( "testWildGetAllConfigDottedNames", start );
	}
	
	
		public void
	testWildGetAllMonitoringDottedNames()
	{
		if ( checkNotOffline( "testMonitoringRefresh" ) )
		{
    		final long	start	= now();
    		final MonitoringDottedNames	dottedNames	= getDomainRoot().getMonitoringDottedNames();
    		final Attribute[] results	= (Attribute[])dottedNames.dottedNameGet( "*" );
    		checkResultsFromWildGet( results );
    		printElapsed( "testWildGetAllMonitoringDottedNames", start );
		}
	}
	
	/**
		Test that we can set (change) a dotted name.
	 */
		public void
	testConfigDottedNameSet()
	{
		final long	start	= now();
		
		final ConfigDottedNames	dottedNames	= getDomainRoot().getConfigDottedNames();
		
		final String	target	= "domain.locale";
		final Object	result	= dottedNames.dottedNameGet( target );
		
		final Attribute	localeAttr	= (Attribute)dottedNames.dottedNameGet( target );
		checkAttribute( localeAttr );
		
		final String	locale	= (String)localeAttr.getValue();
		
		// set to a new value
		Object[]	results	= dottedNames.dottedNameSet( new String[] { target + "=dummy_locale" } );
		assert( results.length == 1 );
		checkAttribute( (Attribute)results[ 0 ] );
		
		// change back to previous value
		final String	restoreString	= target + "=" + (locale == null ? "" : locale);
		results	= dottedNames.dottedNameSet( new String[] { restoreString } );
		
		final Attribute	finalAttr	= (Attribute)dottedNames.dottedNameGet( target );
		assert( (finalAttr.getValue() == null && localeAttr.getValue() == null) ||
			finalAttr.getValue().equals( localeAttr.getValue() ) );
		printElapsed( "testConfigDottedNameSet", start );
	}
	
		public void
	testConfigRefresh()
	{
		final long	start	= now();
		getDomainRoot().getConfigDottedNames().refresh();
		printElapsed( "testConfigRefresh", start );
	}
	
		public void
	testMonitoringRefresh()
	{
		if ( checkNotOffline( "testMonitoringRefresh" ) )
		{
		    final MonitoringDottedNames	dottedNames	= getDomainRoot().getMonitoringDottedNames();
		
		    final long	start	= now();
		    dottedNames.refresh();
		    printElapsed( "testMonitoringRefresh", start );
		}
	}
	
		private int
	testList( final DottedNames	dottedNames, final String dottedName )
	{
		final Object[]	results	= dottedNames.dottedNameList( new String[] { dottedName } );
		
		//trace( dottedName + ": " + toString( results ) );
		for( int i = 0; i < results.length; ++i )
		{
			testList( dottedNames, (String)results[ i ] );
		}

		return( results.length );
	}
	
		public void
	testRecursiveConfigDottedNameList()
	{
		final long	start	= now();
		final ConfigDottedNames	dottedNames	= getDomainRoot().getConfigDottedNames();
		
		final int	numFound	= testList( dottedNames, "domain" );
		assert( numFound >= 4 );	// should be at least 4.
		printElapsed( "testRecursiveConfigDottedNameList", start );
	}
	
		public void
	testRecursiveMonitoringDottedNameList()
	{
		if ( checkNotOffline( "testRecursiveMonitoringDottedNameList" ) )
		{
		    final MonitoringDottedNames	dottedNames	= getDomainRoot().getMonitoringDottedNames();
		
    		final long	start	= now();
    		
    		final int	numFound	= testList( dottedNames, "server" );
    		assert( numFound >= 4 );	// should be at least 4.\
    		
    		testList( dottedNames, "*" );
    		
    		printElapsed( "testRecursiveMonitoringDottedNameList", start );
		}
	}
}











