/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/client/AppserverConnectionSourceTest.java,v 1.4 2005/12/25 03:41:26 tcfujii Exp $
 * $Revision: 1.4 $
 * $Date: 2005/12/25 03:41:26 $
 */
package com.sun.enterprise.management.client;

import java.io.IOException;

import com.sun.appserv.management.client.AppserverConnectionSource;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
	Tests AppserverConnectionSource.
	
	Note that no actual connect test can be done through normal junit tests since there
	is no host/port available and no guarantee of a running server.  All other aspects
	can be tested.
 */
public final class AppserverConnectionSourceTest extends AMXTestBase
{
		public
	AppserverConnectionSourceTest( )
	{
	}
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( false );
	}
	
		private static void
	testConnect(
		final String	host,
		final int		port,
		final String	protocol,
		final String	user,
		final String	password )
		throws IOException
	{
		final AppserverConnectionSource	source	=
			new AppserverConnectionSource( protocol, host, port, user, password, null);
		
		source.getMBeanServerConnection( true );
		
	}
	
		public void
	testConnect()
		throws Exception
	{
		final String	host		= (String)getEnvValue( "HOST" );
		final String	port		= (String)getEnvValue( "PORT" );
		final String	protocol	= (String)getEnvValue( "PROTOCOL" );
		final String	user		= (String)getEnvValue( "USER" );
		final String	password	= (String)getEnvValue( "PASSWORD" );
		
		if ( host == null || port == null || protocol == null ||
			user == null || password == null ||
			! AppserverConnectionSource.isSupportedProtocol( protocol ) )
		{
			trace( "AppserverConnectionSourceTest: skipped connect test; missing config:" +
				"host = " + host +
				", port = " + port +
				", protocol = " + protocol  +
				", user = " + user  +
				", password = " + password );
		}
		else
		{
			testConnect( host, new Integer( port ).intValue(), protocol, user, password );
		}
	}
	
		private AppserverConnectionSource
	create( final String protocol )
	{
		return( new AppserverConnectionSource( protocol, "localhost", 9999, "admin", "admin123", null) );
	}
	
		public void
	testCreateS1ASHTTP()
	{
		create( AppserverConnectionSource.PROTOCOL_HTTP );
	}
	
		public void
	testCreateRMI()
	{
		create( AppserverConnectionSource.PROTOCOL_RMI );
	}
	
		public void
	testCreateIllegal()
	{
		try
		{
			create( "jmxmp" );
		}
		catch( IllegalArgumentException e )
		{
			// good
		}
	}
	
		public void
	testToString()
	{
		create( AppserverConnectionSource.PROTOCOL_RMI ).toString();
		create( AppserverConnectionSource.PROTOCOL_HTTP ).toString();
	}
}






