/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;


public final class UploadInfo extends UpDownInfo
{
	private final String		mName;
	private final long			mTotalSize;
	private FileOutputStream	mOutputStream;
	private long			mWrittenSoFar;
	
	
		public
	UploadInfo(
		final Object	id,
		final String	name,
		final long		totalSize )
		throws IOException
	{
		super( id, createTempFile( id, name, totalSize ) );
		
		mName	= name;
		
		mTotalSize	= totalSize;
		
		getFile().createNewFile();
		getFile().deleteOnExit();
		mOutputStream	= new FileOutputStream( getFile() );
		
		mWrittenSoFar	= 0;
	}
	
		private static File
	createTempFile( final Object id, final String name, final long totalSize )
		throws IOException
	{
        final String tempName = (name != null) ? name : id + "_" + totalSize;
        File  actual   = new File( tempName );
        if ( actual.exists() )
        {
            actual  = File.createTempFile( tempName, null );
        }
        return( actual ); 
	}
	
		public boolean
	isDone()
	{
		return( mWrittenSoFar == mTotalSize );
	}
	
	
	/**
		@return true if done, false otherwise
	 */
		public boolean
	write( final byte[] bytes )
		throws IOException
	{
		if ( isDone() || mWrittenSoFar + bytes.length > mTotalSize )
		{
			throw new IllegalArgumentException( "too many bytes" );
		}
		getOutputStream().write( bytes );
		
		mWrittenSoFar	+= bytes.length;
		
		if ( isDone() )
		{
			mOutputStream.close();
			mOutputStream	= null;
		}
		
		accessed();
		
		return( isDone() );
	}
	
	
	
		public long
	getTotalSize()
	{
		return( mTotalSize );
	}
	
		public void
	cleanup()
		throws IOException
	{
		if ( mOutputStream != null )
		{
			mOutputStream.close();
		}
		
		getFile().delete();
	}
	
		private FileOutputStream
	getOutputStream()
	{
		return( mOutputStream );
	}
}


