/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;

import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;

import javax.management.ObjectName;

import com.sun.appserv.management.base.XTypes;


 
/**
	Maps an AMX j2eeType to/from and "old" (8.0) monitor type.
	
	See {@link com.sun.appserv.management.base.XTypes}
 */
public final class OldMonitorTypes extends OldTypesBase
{
    private static OldMonitorTypes  INSTANCE;
    
		private
    OldMonitorTypes()
	{
		super();
	}
	
		public static synchronized OldMonitorTypes
	getInstance()
	{
	    if ( INSTANCE == null )
	    {
	        INSTANCE	= new OldMonitorTypes();
	    }

		return( INSTANCE );
	}
	
	/**
		These are delegates that require a config name only, no other keys
		other than category=monitor.
		
		If this list is updated, be sure to update the unit test
		com.sun.enterprise.management.monitor.ComSunAppservMonitorTest.
	 */
		void
	initMap()
	{
		/* monitoring types */
		add(  XTypes.SERVER_ROOT_MONITOR, "root");
		add(  XTypes.SERVER_ROOT_MONITOR, "server");
		add(  XTypes.JVM_MONITOR, "jvm");
		
		add(  XTypes.APPLICATION_MONITOR, "application");
		add(  XTypes.EJB_MODULE_MONITOR, "ejb-module");
		add(  XTypes.EJB_MODULE_MONITOR, "standalone-ejb-module");
		
		// in reality, only the old com.sun.appserv type 'ejb' exists as of 15 Oct 2004
		// see bug #6179958
		add(  XTypes.STATEFUL_SESSION_BEAN_MONITOR, "stateful-bean-monitor");
		add(  XTypes.STATELESS_SESSION_BEAN_MONITOR, "stateless-bean-monitor");
		add(  XTypes.ENTITY_BEAN_MONITOR, "entity-bean-monitor");
		add(  XTypes.MESSAGE_DRIVEN_BEAN_MONITOR, "message-drive-bean-monitor");
		
		
		add(  XTypes.BEAN_POOL_MONITOR, "bean-pool");
		add(  XTypes.BEAN_CACHE_MONITOR, "bean-cache");
		add(  XTypes.BEAN_METHOD_MONITOR, "bean-method");
		add(  XTypes.SERVLET_MONITOR, "servlet");
		add(  XTypes.HTTP_SERVICE_MONITOR, "http-service");
		add(  XTypes.FILE_CACHE_MONITOR, "file-cache");

		add(  XTypes.HTTP_SERVICE_VIRTUAL_SERVER_MONITOR, "virtual-server");
		add(  XTypes.WEB_MODULE_VIRTUAL_SERVER_MONITOR, "webmodule-virtual-server");

		add(  XTypes.HTTP_LISTENER_MONITOR, "http-listener");
		add(  XTypes.TRANSACTION_SERVICE_MONITOR, "transaction-service");
		add(  XTypes.THREAD_POOL_MONITOR, "thread-pool");
		add(  XTypes.CONNECTION_MANAGER_MONITOR, "connection-manager");
		add(  XTypes.JDBC_CONNECTION_POOL_MONITOR, "jdbc-connection-pool");
		add(  XTypes.CONNECTOR_CONNECTION_POOL_MONITOR, "connector-connection-pool");
		
		add(  XTypes.KEEP_ALIVE_MONITOR, "keep-alive");
		add(  XTypes.CONNECTION_QUEUE_MONITOR, "connection-queue");

		add(  XTypes.WEBSERVICE_ENDPOINT_MONITOR, "webservice-endpoint");
	}

}








