/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/deploy/DownloadFileSource.java,v 1.3 2005/12/25 03:39:58 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:39:58 $
 */
package com.sun.enterprise.management.deploy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
	This class is responsible for generating a File for downloading, given
	a moduleID and filename within that module.  The file may be pre-existing,
	in which case isTempFile() should return false, or it may be a generated
	temporary file, in which case isTempFile() should return true.  If isTempFile()
	returns true, the caller will delete the file at some point.
 */
final class DownloadFileSource 
{
	private final String	mModuleID;
	private final String	mFilename;
	
		public
	DownloadFileSource(
		final String	moduleID,
		final String	filename )
		throws IOException
	{
		mModuleID	= moduleID;
		mFilename	= filename;
	}
	
		public File
	getDownloadFile()
		throws IOException
	{
		return( createDownloadFile( mModuleID, mFilename ) );
	}
	
		public boolean
	isTempFile()
	{
		return( true );
	}
	
	/**
		This implementation is for testing; the real one needs to find or produce
		a file corresponding to the requested module and filename.
	 */
		private File
	createDownloadFile( 
		final String	moduleID,
		final String	filename)
		throws IOException
	{
		final String	name	= "./" + moduleID + "_" + filename + System.currentTimeMillis();
		
		final File theFile	= new File( name );
		theFile.createNewFile();
		
		final FileOutputStream	out	= new FileOutputStream( theFile );
		
		final byte[]	temp	= new byte[ 1024 * 1024 ];
		
		long	remaining	= temp.length * 10;
		while ( remaining != 0 )
		{
			out.write( temp );
			assert( remaining >= temp.length );
			remaining	-= temp.length;
		}
		
		out.close();
		
		return( theFile );
	}
}

