/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.deploy;

import java.util.Collections;
import java.util.Map;
import java.util.HashMap;

import java.io.File;

import com.sun.appserv.management.deploy.DeploymentSource;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.util.misc.TypeCast;


public final class DeployThreadParams
{
	private final File				mDeployFile;
	private final File				mPlanFile;
	private final Map<String,Object>				mOptions;
	private final DeploymentSource	mDeploymentSource;
	private final DeploymentSource	mDeploymentPlan;
	private final QueryMgr		mQueryMgr;
	
		private
	DeployThreadParams(
		final QueryMgr		    queryMgr,
		final Map<String,?>		options,
		final File				deployFile,
		final File				planFile,
		final DeploymentSource	source,
		final DeploymentSource	plan )
	{
		assert( (deployFile == null && source != null) ||
			(deployFile != null && source == null) );
		
		mDeployFile			= deployFile;
		mPlanFile			= planFile;
		mOptions			= options == null ?
				new HashMap<String,Object>() :
				   Collections.unmodifiableMap(
				    TypeCast.checkMap( options, String.class, Object.class));
		mDeploymentSource	= source;
		mDeploymentPlan		= plan;
		mQueryMgr			= queryMgr;
	}
	
	
		public
	DeployThreadParams(
		final QueryMgr	queryMgr,
		final Map<String,?>			options,
		final File			deployFile,
		final File			planFile )
	{
		this( queryMgr, options, deployFile, planFile, null, null );
	}
	
		public
	DeployThreadParams(
		final QueryMgr		queryMgr,
		final Map<String,?>				options,
		final DeploymentSource	source,
		final DeploymentSource	plan )
	{
		this( queryMgr, options, null, null, source, plan );
	}
	
	public File				getDeployFile()			{ return( mDeployFile ); }
	public File				getPlanFile()			{ return( mPlanFile ); }
	public Map<String,?>				getOptions()			{ return( mOptions ); }
	public QueryMgr	getQueryMgr()		{ return( mQueryMgr ); }
	public DeploymentSource	getDeploymentSource()	{ return( mDeploymentSource ); }
	public DeploymentSource	getDeploymentPlan()		{ return( mDeploymentPlan ); }
}














