/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;

import com.sun.enterprise.management.config.AMXConfigImplBase;

import com.sun.enterprise.management.support.oldconfig.OldDomainMBean;
import com.sun.enterprise.management.support.Delegate;
import com.sun.enterprise.management.support.AMXAttributeNameMapper;


/**
 */
public class ServerConfigBase extends AMXConfigImplBase
{
		public
	ServerConfigBase(
		final String 		j2eeType,
		final Delegate		delegate )
	{
		super( delegate);
		
	}

		protected void
	addCustomMappings( final AMXAttributeNameMapper mapper )
	{
	    super.addCustomMappings( mapper );
	    
		// these require custom mappings due to different names...
		mapper.matchName( "ReferencedConfigName", "ConfigRef");
		mapper.matchName( "ReferencedNodeAgentName", "NodeAgentRef" );
	}


	private static final String	TEMPLATE_PREFIX	= "${";
		public boolean
	isTemplateString( final String s )
	{
		// at least one character must be between the {} 
		return( s != null &&
			s.startsWith( TEMPLATE_PREFIX ) &&
			s.indexOf( "}" ) >= TEMPLATE_PREFIX.length() + 1 );
	}
	
		public String
	resolveTemplateString( final String template )
	{
		String	result	= template;
		
		if ( isTemplateString( template ) )
		{
			final String			myName		= getName();
			final OldDomainMBean	oldDomain	= getOldConfigProxies().getOldDomainMBean();
			
   			try
   			{
   				result	= oldDomain.resolveTokens( template, myName);
   			}
   			catch( Exception e )
   			{
   				getMBeanLogger().warning( "Can't resolve: " + template + ", " + e);
   				e.printStackTrace();
   				throw new IllegalArgumentException( template );
   			}
		}
		return( result );
	}
	
}








