/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/MailResourceConfigFactory.java,v 1.6 2006/03/17 03:34:15 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/17 03:34:15 $
 */


package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

	
import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.misc.GSetUtil;

import com.sun.appserv.management.config.MailResourceConfigKeys;
import com.sun.appserv.management.config.ResourceConfigKeys;
import com.sun.appserv.management.config.ResourceRefConfig;
import com.sun.appserv.management.config.Description;

public final class MailResourceConfigFactory  extends ResourceFactoryImplBase
{
		public
	MailResourceConfigFactory(
		final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}

          
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet( 
		MailResourceConfigKeys.STORE_PROTOCOL_KEY,
		MailResourceConfigKeys.STORE_PROTOCOL_CLASS_KEY,
		MailResourceConfigKeys.TRANSPORT_PROTOCOL_KEY,
		MailResourceConfigKeys.TRANSPORT_PROTOCOL_CLASS_KEY,
		MailResourceConfigKeys.DEBUG_KEY,
        Description.DESCRIPTION_KEY,        
		ResourceConfigKeys.ENABLED_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}
	
	
	public static final String HOST_KEY                     = "Host";
	public static final String USER_KEY                     = "User";
	public static final String FROM_KEY                     = "From";
	
	      
        protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( CONFIG_NAME_KEY, "jndi-name" ) );
	}

                
        /**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs )
	{
		trace( "MailResourceConfigFactory.createOldChildConfig: creating using: " +
			stringify( translatedAttrs ) );
			
		final ObjectName	objectName	=
				getOldResourcesMBean().createMailResource( translatedAttrs );
		
		return( objectName );
	}


	/**
		Create a new &lt;mail-resource>
		
		@param jndiName			
		@param host
                @param user
                @param from
		@param optional
	 */
		public ObjectName
	create( String      jndiName,
		String          host,
		String          user,
		String          from,
		Map<String,String>   			optional)
	{
		final String[] requiredParams = new String[]
		{
		HOST_KEY,       host,
		USER_KEY,       user,
		FROM_KEY,       from,
		};
		    
		final Map<String,String> params	= initParams( jndiName, requiredParams, optional );

		final ObjectName	amxName = createNamedChild( jndiName, params );

		return( amxName );                                           
	}
	
		final protected void
	removeByName( String name )
	{
	    final Set<ResourceRefConfig> refs   =
	        findAllRefConfigs( XTypes.MAIL_RESOURCE_CONFIG, name );
	    
	    if ( refs.size() == 0 )
	    {
		    getOldResourcesMBean().removeMailResourceByJndiName( name );
	    }
	    else
	    {
    	    for( final ResourceRefConfig ref : refs )
    	    {
    	        final String target = ref.getContainer().getName();
		        getOldResourcesMBean().deleteMailResource( name, target );
    	    }
		}
	}
	
	
	
}

