/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/LoadBalancerConfigFactory.java,v 1.5 2006/03/09 20:30:39 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:39 $
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Properties;
import java.util.Collections;

import javax.management.AttributeList;
import javax.management.ObjectName;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.config.LoadBalancerConfigKeys;

final class LoadBalancerConfigFactory extends ConfigFactory {

    public LoadBalancerConfigFactory(final ConfigFactoryCallback callbacks) {
        super(callbacks);
    }

    private final Set<String> LEGAL_OPTIONAL_KEYS = 
        GSetUtil.newUnmodifiableStringSet(
            LoadBalancerConfigKeys.NAME,
            LoadBalancerConfigKeys.LB_CONFIG_NAME,
            LoadBalancerConfigKeys.AUTO_APPLY_ENABLED );

    protected Set<String> getLegalOptionalCreateKeys()  {
        return LEGAL_OPTIONAL_KEYS;
    }

    public ObjectName create(String name, String lbConfigName, 
        boolean autoApplyEnabled, Map<String,String> optional) {
        final String[] required =
            new String[] {"lb-config-name", lbConfigName, "auto-apply-enabled", "" + autoApplyEnabled };
        final Map<String,String> params = initParams(name, required, optional);
        final ObjectName amxName = createNamedChild(name, params);
        return amxName;
    }

    protected ObjectName createOldChildConfig(final AttributeList translatedAttrs) {
        return getOldConfigProxies().getOldLoadBalancers().createLoadBalancer(translatedAttrs);
    }
	
    public void removeByName(String name) {
        getOldConfigProxies().getOldLoadBalancers().removeLoadBalancerByName(name);
    }    
}





