/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 */

package com.sun.enterprise.management.config;

import java.util.Map;

import javax.management.ObjectName;

import com.sun.appserv.management.base.XTypes;

import com.sun.enterprise.management.config.AMXConfigImplBase;
import com.sun.enterprise.management.support.Delegate;
import com.sun.appserv.management.config.LBConfig;
import com.sun.appserv.management.base.Util;


/**
	Configuration for the &lt;lb-config&gt; element.
*/
public final class LBConfigImpl extends AMXConfigImplBase 
        implements ConfigFactoryCallback {
    
    public LBConfigImpl(final Delegate delegate) {
        super(delegate);
    }
        
    public Map<String,ObjectName>	getClusterRefConfigObjectNameMap() {
        return(getContaineeObjectNameMap(XTypes.CLUSTER_REF_CONFIG));
    }

    public Map<String,ObjectName>	getServerRefConfigObjectNameMap() {
        return(getContaineeObjectNameMap(XTypes.SERVER_REF_CONFIG));
    }

    private ClusterRefConfigFactory getClusterRefConfigFactory() {
        return new ClusterRefConfigFactory(this);
    }

    public ObjectName createClusterRefConfig(String referencedClusterName, 
        String lbPolicy, String lbPolicyModule) {

        return getClusterRefConfigFactory().create(referencedClusterName, 
        lbPolicy, lbPolicyModule);
    }

    public void removeClusterRefConfig( final String name) {
        final Map<String,ObjectName> items = getClusterRefConfigObjectNameMap();
        getClusterRefConfigFactory().remove(Util.getObjectName(items, name));
    }

    private ServerRefConfigFactory getServerRefConfigFactory() {
        return new ServerRefConfigFactory(this);
    }

    public ObjectName createServerRefConfig(final String referencedServerName, 
        final Map<String,String> optional) {

        return getServerRefConfigFactory().create(referencedServerName, optional);
    }

    public ObjectName createServerRefConfig(final String referencedServerName, 
        final String disableTimeoutInMinutes, final boolean lbEnabled, 
        final boolean enabled) {

        return getServerRefConfigFactory().create(referencedServerName, 
        disableTimeoutInMinutes, lbEnabled, enabled);
    }

    public void removeServerRefConfig( final String name) {
        final Map<String,ObjectName> items = getServerRefConfigObjectNameMap();
        getServerRefConfigFactory().remove(Util.getObjectName(items, name));
    }
}