/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/CustomResourceConfigFactory.java,v 1.5 2006/03/09 20:30:37 llc Exp $
 * $Revision: 1.5 $
 * $Date: 2006/03/09 20:30:37 $
 */


package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.Map;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.util.misc.MapUtil;

import com.sun.appserv.management.config.ResourceRefConfig;

/**
	
 */

public final class CustomResourceConfigFactory extends ResourceFactoryImplBase
	//implements CustomResourceConfigMgr
{
		public
	CustomResourceConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
	}
       

  
                
        /**
		The caller is responsible for dealing with any Properties.
	 */
		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs )
	{
		trace( "CustomResourceConfigFactory.createOldChildConfig: creating using: " +
			stringify( translatedAttrs ) );
			
		final ObjectName	objectName	=
				getOldResourcesMBean().createCustomResource( translatedAttrs );

		return objectName;
	}
	
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( CONFIG_NAME_KEY, "jndi-name" ) );
	}
	
	public static final String	RES_TYPE_KEY		= "ResType";
	public static final String	FACTORY_CLASS_KEY	= "FactoryClass";
	
	/**
 	 Creates a new custom resource.	

	 @param jndiName
	 @param resType
	 @param factoryClass
	 @param optional 
	 */
	public ObjectName create(
		String jndiName,
		String resType,
		String factoryClass,
		Map<String,String> optional)
	{
		final String[] requiredParams = new String[]
		{
			RES_TYPE_KEY,       resType,
			FACTORY_CLASS_KEY,  factoryClass,
		};
                
		final Map<String,String> params	= initParams( jndiName, requiredParams, optional );
		
		final ObjectName	amxName = createNamedChild( jndiName, params );
		
		return( amxName );	
	}
	
		
		protected void
	removeByName( final String name )
	{
	    final Set<ResourceRefConfig> refs   =
	        findAllRefConfigs( XTypes.CUSTOM_RESOURCE_CONFIG, name );
	    
	    if ( refs.size() == 0 )
	    {
		    getOldResourcesMBean().removeCustomResourceByJndiName( name );
	    }
	    else
	    {
    	    for( final ResourceRefConfig ref : refs )
    	    {
    	        final String target = ref.getContainer().getName();
		        getOldResourcesMBean().deleteCustomResource( name, target );
    	    }
		}
    }
}














