/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Set;
import java.util.Collections;

import javax.management.ObjectName;
import javax.management.AttributeList;

import com.sun.enterprise.management.support.oldconfig.OldHTTPServiceMBean;

import com.sun.appserv.management.config.ConnectionPoolConfigKeys;

import com.sun.appserv.management.util.misc.GSetUtil;


final class ConnectionPoolConfigFactory extends ConfigFactory
{
	private final OldHTTPServiceMBean	mOldHTTPServiceMBean;
	
		public
	ConnectionPoolConfigFactory( final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
		
		mOldHTTPServiceMBean	=
			getOldConfigProxies().getOldHTTPServiceMBean( getConfigName() );
	}
	
	private final Set<String>	LEGAL_OPTIONAL_KEYS	= 
		GSetUtil.newUnmodifiableStringSet(
		ConnectionPoolConfigKeys.QUEUE_SIZE_IN_BYTES_KEY,
		ConnectionPoolConfigKeys.MAX_PENDING_COUNT_KEY,
		ConnectionPoolConfigKeys.RECEIVE_BUFFER_SIZE_IN_BYTES_KEY,
		ConnectionPoolConfigKeys.SEND_BUFFER_SIZE_IN_BYTES_KEY );
	
	    protected Set<String>
	getLegalOptionalCreateKeys()
	{
		return( LEGAL_OPTIONAL_KEYS );
	}



		public ObjectName	
	create( final Map<String,String> optional )
	{
		final Map<String,String>	params	= initParams( optional );

		trace( "params as processed: " + stringify( params ) );

		final ObjectName	amxName	= createChild( params );
		
		return( amxName );
	}

		protected void		
	internalRemove( final ObjectName objectName )
	{
		mOldHTTPServiceMBean.removeConnectionPool();
	}

		protected ObjectName
	createOldChildConfig( final AttributeList attrs )
	{
		return mOldHTTPServiceMBean.createConnectionPool( attrs );
	}
}




