/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/ClusterConfigFactory.java,v 1.4 2006/03/09 20:30:36 llc Exp $
 * $Revision: 1.4 $
 * $Date: 2006/03/09 20:30:36 $
 */
package com.sun.enterprise.management.config;

import java.util.Set;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;
import java.util.Properties;
import java.util.Collections;

import javax.management.AttributeList;
import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

import com.sun.enterprise.management.support.oldconfig.OldClustersMBean;

final class ClusterConfigFactory extends ConfigFactory
{
	private final OldClustersMBean	mOldClustersMBean;
	
		public
	ClusterConfigFactory(
		final ConfigFactoryCallback	callbacks )
	{
		super( callbacks );
		
		mOldClustersMBean	= getOldConfigProxies().getOldClustersMBean();
	}

		protected ObjectName
	createOldChildConfig(
		final AttributeList translatedAttrs, 
		final Properties	props )
	{
		// YUCK--createCluster( AttributeList ) cannot be called;
		// it won't work correctly; we must make the call explicity.
		final Map<String,String>	m	= JMXUtil.attributeListToStringMap( translatedAttrs );
		
		final String	config	= (String)m.get( "config-ref" );
		final String	name	= (String)m.get( "name" );
		
		return mOldClustersMBean.createCluster( name, config, props );
	}
	
	private final static String	  REFERENCED_CONFIG_NAME	= "ReferencedConfigName";
	
		protected Map<String,String>
	getParamNameOverrides()
	{
		return( MapUtil.newMap( REFERENCED_CONFIG_NAME, "config-ref" ) );
	}
	        
		private void
	checkConfigExists( final String	configName )
	{
		final Map<String,ConfigConfig>	configs	= getDomainConfig().getConfigConfigMap();
		
		if( ! configs.keySet().contains( configName ) )
		{
			throw new IllegalArgumentException( "No ConfigConfig exists with the name: " + configName );
		}
	}
	
		private boolean
	clusterExists( final String name )
	{
		return getDomainConfig().getClusterConfigMap().keySet().contains( name );
	}
	
		public ObjectName
	create(
		final String name, 
		final String configName, 
		final Map<String,String> optional )
	{
		if ( configName != null )
		{
			checkNonEmptyString( configName, "configName" );
			checkConfigExists( configName );
			
			// This is explicitly disallowed
			if ( configName.equals( "server-config" ) || configName.equals( "default-config" ) )
			{
				throw new IllegalArgumentException( configName );
			}
		}
		
		if ( clusterExists( name )  )
		{
			throw new IllegalArgumentException( "Cluster already exists: " + quote( name ) );
		}

		
        final String[] requiredParams =
		{
			"ReferencedConfigName",		configName,
		};
		
		final Map<String,String> params	= initParams( name, requiredParams, optional );
		
		return createNamedChild( name, params );
	}
	
	// default-config to be used
		public ObjectName
	create(
		final String name, 
		final Map<String,String> optional )
	{
		return create( name, null, optional );
	}

    protected void internalRemove(final ObjectName objectName){
        final String name = Util.getName(objectName);
        if ( ! clusterExists( name ) )
		{
			throw new IllegalArgumentException( "No such cluster: " + quote( name ) );
		}
        mOldClustersMBean.deleteCluster(name);
    }
}





