/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/config/AuditModuleConfigFactory.java,v 1.6 2006/03/09 20:30:36 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:36 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.Properties;

import javax.management.ObjectName;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.jmx.JMXUtil;
import com.sun.appserv.management.config.PropertiesAccess;

import com.sun.enterprise.management.support.oldconfig.OldSecurityServiceMBean;

/**
 */
public final class AuditModuleConfigFactory extends ConfigFactory
{
	private static final String AUDIT_ON_PROPERTY_KEY	=
		PropertiesAccess.PROPERTY_PREFIX + "auditOn";
		
	private static final	String	CLASSNAME_KEY		= "Classname";

	private final OldSecurityServiceMBean	mOldSecurityServiceMBean;
	

		public
	AuditModuleConfigFactory( final ConfigFactoryCallback callbacks )
	{
		super( callbacks );
		
		mOldSecurityServiceMBean =
		    getOldConfigProxies().getOldSecurityServiceMBean( getConfigName() );
	}
	
		public ObjectName	
	create( String name, String className, boolean auditOn, 
		Map<String,String> reservedForFutureUse )
	{
		final String[] requiredParams = {	
			CLASSNAME_KEY,			className,	
			AUDIT_ON_PROPERTY_KEY,	Boolean.toString(auditOn),
		};

		final Map<String,String> params = initParams( name, requiredParams, reservedForFutureUse );

		final ObjectName amxName = createNamedChild( name, params );

		return amxName;
	}

	
		protected void		
	internalRemove( final ObjectName objectName )
	{
		final String	name	= Util.getName( objectName );
		
		mOldSecurityServiceMBean.removeAuditModuleByName(name);
	}

		protected ObjectName
	createOldChildConfig( final AttributeList translatedAttrs )
	{
		return mOldSecurityServiceMBean.createAuditModule( translatedAttrs );
	}
}




