/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.backup;

import java.util.ResourceBundle;
import java.text.MessageFormat;

/**
 *
 * @author  bnevins
 */
class StringHelper
{
	private StringHelper()
	{
	}
	
	/**
	 * @return the String from LocalStrings or the supplied String if it doesn't exist
	 */
	
	static String get(String s)
	{
		try 
		{
			return bundle.getString(s);
		} 
		catch (Exception e) 
		{
			// it is not an error to have no key...
			return s;
		}
	}

	/** 
	 * Convenience method which calls get(String, Object[])
	 * @return the String from LocalStrings or the supplied String if it doesn't exist --
	 * using the one supplied argument
	 * @see get(String, Object[])
	 */
	static String get(String s, Object o)
	{
		return get(s, new Object[] { o });
	}

	/** 
	 * Convenience method which calls get(String, Object[])
	 * @return the String from LocalStrings or the supplied String if it doesn't exist --
	 * using the two supplied arguments
	 * @see get(String, Object[])
	 */
	static String get(String s, Object o1, Object o2)
	{
		return get(s, new Object[] { o1, o2 });
	}
	
	/** 
	 * Convenience method which calls get(String, Object[])
	 * @return the String from LocalStrings or the supplied String if it doesn't exist --
	 * using the three supplied arguments
	 * @see get(String, Object[])
	 */
	static String get(String s, Object o1, Object o2, Object o3)
	{
		return get(s, new Object[] { o1, o2, o3 });
	}
	
	/**
	 * Get and format a String from LocalStrings.properties
	 * @return the String from LocalStrings or the supplied String if it doesn't exist --
	 * using the array of supplied Object arguments
	 */
	static String get(String s, Object[] objects)
	{
		s = get(s);
		
		try
		{
			MessageFormat mf = new MessageFormat(s);
			return mf.format(objects);
		}
		catch(Exception e)
		{
			return s;
		}
	}

	///////////////////////////////////////////////////////////////////////////
	
	private static	ResourceBundle bundle;

	static
	{
		try 
		{   
			String props = StringHelper.class.getPackage().getName() + ".LocalStrings";
			bundle = ResourceBundle.getBundle(props);
		} 
		catch (Exception e) 
		{
			LoggerHelper.warning("No resource bundle found: " + Constants.exceptionResourceBundle, e);
			bundle = null;
		}
	}
	
	static void main(String[] notUsed)
	{
		System.out.println("key=backup-res.BadProjectBackupDir, value =" + get("backup-res.BadProjectBackupDir"));
	}
}


