/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorWizardWindowViewBean;


/**
 *
 */
public class WizardWindowViewBeanDescriptor extends ViewDescriptor {

    /**
     *	Constructor
     */
    public WizardWindowViewBeanDescriptor(String name) {
	super(name);
    }

    
    /**
     *	This is a factory method.  It will create a WizardWindowViewBean.
     *
     *	@param	ctx		The RequestContext
     *	@param	container	The container for the newly created 
     *	@param	name		The Name of the View to be created.
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Caching is done by view.getName()... since this always returns the
	// 1st one called, it will only cache by the first one called.  Since
	// WizardWindow is called first, it will be cached under WizardWindow.
	if (name.equals("com.sun.web.ui.servlet.wizard.WizardWindowViewBean")) {
	    try {
		return ctx.getViewBeanManager().getViewBean("WizardWindow");
	    } catch (ClassNotFoundException ex) {
		throw new FrameworkException(
		    "WizardWindowViewBean is called by 2 names: " +
		    "'WizardWindow' and 'com.sun.web.ui.servlet.wizard." +
		    "WizardWindowViewBean'.  For this reason, you must " +
		    "register both of these in the ViewXML!  The "+
		    "WizardWindowViewBeanDescriptor knows how to deal with " +
		    "this.", ex, this, container);
	    }
	}
	return new DescriptorWizardWindowViewBean(ctx, name, this);
    }
}
