/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelFieldBinding;
import com.iplanet.jato.view.BasicDisplayField;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.HtmlDisplayFieldBase;

import java.util.ArrayList;
import java.util.List;


/**
 *
 */
public class DisplayFieldDescriptor extends ViewDescriptor {

    /**
     *	This constructor creates a DisplayFieldDescriptor.  Name is
     *	required to create a DisplayFieldDescriptor.
     *
     *	@param name		Instance name for the described DisplayField
     */
    public DisplayFieldDescriptor(String name) {
	super(name);
    }


    /**
     *	This method will set the default value if the view is a DisplayField
     *	and a DefaultValue has been supplied.
     */
    protected void setDefaultValue(View view) {
	// We first check (value != null) b/c this is relatively inexpensive
	// compared to instanceof and DisplayField.getValue(), also it is very
	// likely that a default value is not supplied.
	Object value = getInitialValue();
	if (value != null) {
	    if (view instanceof DisplayField) {
		DisplayField df = ((DisplayField)view);
		if (df.getValue() == null) {
		    // Only set a default value if no value has been set yet
		    df.setValue(value);
		}
	    }
	}
    }


    /**
     *
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	// Create the field
	BasicDisplayField field = new BasicDisplayField(container, name);

	// Set the ModelFieldBinding
	setModelFieldBinding(field, getModelFieldName());

	// Set the default value if supplied
	setDefaultValue(field);

	return field;
    }


    /**
     *	This method retrieves the model field name that this field is bound to.
     *	This uses the MODEL_FIELD_NAME parameter.
     *
     *	@return The bound name (will return getName() if MODEL_FIELD_NAME is
     *		not supplied).
     */
    public String getModelFieldName() {
	String value = (String)getParameter(MODEL_FIELD_NAME);
	if (value == null) {
	    value = getName();
	}
	return value;
    }

    /**
     *	<P> This method sets the Model field name that the given
     *	    DisplayFieldImpl should be bound.  It will retrieve the bound name
     *	    via the getModelFieldName method.</P>
     *
     *	@param	field	    DisplayFieldImpl to bind
     *
     *	@see #getModelFieldName()
     */
    public void setBoundName(DisplayField field) {
	if (field instanceof DisplayFieldImpl) {
	    setBoundName((DisplayFieldImpl)field, getModelFieldName());
	} else if (field instanceof BasicDisplayField) {
	    setModelFieldBinding((BasicDisplayField)field, getModelFieldName());
	}
    }

    /**
     *	<P> This method sets the Model field name that the given
     *	    DisplayFieldImpl should be bound.</P>
     *
     *	@param	field	DisplayFieldImpl to bind
     *	@param	name	The model field name.
     */
    public void setBoundName(DisplayFieldImpl field, String name) {
	field.setBoundName(name);
    }

    /**
     *	<P> This method sets the ModelFieldBinding for the given
     *	    BasicDisplayField.</P>
     *
     *	@param	field	    The BasicDisplayField
     *	@param	name	    The model field name.
     */
    public void setModelFieldBinding(BasicDisplayField field, String name) {
	field.setModelFieldBinding(new ModelFieldBinding(name));
    }

    /**
     *	Returns the initial value (if any).  If InitialValue is null, then no
     *	value will be set (the model may already have a value, or provide an
     *	initial value).
     *
     *	@return	The initial value to set to the DisplayField upon creation
     */
    public Object getInitialValue() {
	return getParameter(DEFAULT_VALUE);
    }


    /**
     *	This method looks for extra HTML supplied as a parameter and applies
     *	it to the given HtmlDisplayField.
     *
     *	@param	view	The HtmlDisplayField to recieve the extra HTML
     *
     *	@return The extraHtml String
     */
    public String setExtraHtml(HtmlDisplayFieldBase view) {
// FIXME: JATO bug prevents us from using HtmlDisplayField, setExtraHtml
// FIXME: not defined in this Interface (CR#: 6175891)
        String extra = (String)getParameter(EXTRA_HTML);
	if ((extra != null) && (view != null)) {
	    view.setExtraHtml(extra);
	}
	return extra;
    }

    /**
     *   <p> This method checks the {@link #DISABLED} parameter and returns
     *       true if the display field should be disabled.</p>
     */
    public boolean isDisabled() {
        return Boolean.parseBoolean((""+getParameter(DISABLED)).toString());
    }

    /**
     *  This parameter specifies if this field should be disabled.
     *  ("disabled")
     */
    public static final String DISABLED   = "disabled";



    /**
     *	This parameter specifies the model's field name that this field is
     *	bound to.  If a parameter of this name is supplied, its value will be
     *	used for the model field; otherwise this.getName() will be used as the
     *	model field name. ("modelFieldName")
     */
    public static final String	MODEL_FIELD_NAME= "modelFieldName";

    /**
     *	DEFAULT_VALUE (which is set to "defaultValue") is the name of the
     *	Paramter that can be specified to supply a default value to a display
     *	field.
     */
    public static final String	DEFAULT_VALUE	= "defaultValue";


    /**
     *	EXTRA_HTML (which is set to "extraHtml") is the name of the Paramter
     *	that can be specified to supply extra HTML to this field.
     */
    public static final String	EXTRA_HTML	= "extraHtml";
}
