/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.BasicChoiceDisplayField;
import com.iplanet.jato.view.Choice;
import com.iplanet.jato.view.SimpleChoice;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;

import java.util.ArrayList;
import java.util.List;

/**
 *
 */
public class ChoiceFieldDescriptor extends DisplayFieldDescriptor {

    /**
     *	This constructor creates a DisplayFieldDescriptor.  Name is
     *	required to create a ChoiceFieldDescriptor.
     *
     *	@param name		Instance name for the described ChoiceField
     */
    public ChoiceFieldDescriptor(String name) {
	super(name);
    }


    /**
     *
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
	BasicChoiceDisplayField choice =
	    new BasicChoiceDisplayField(container, name);
	setModelFieldBinding(choice, getModelFieldName());
	Object options = getParameter(LABELS);
	if (options != null) {
	    if (options instanceof String) {
		List tmp = new ArrayList();
		tmp.add(options);
		options = tmp;
	    }
	    List optionList = (List)options;

	    Object values = getParameter(VALUES);
	    List valueList = optionList;
	    if (values != null) {
		if (values instanceof String) {
		    List tmp = new ArrayList();
		    tmp.add(values);
		    values = tmp;
		}
		valueList = (List)values;
		if (valueList.size() != optionList.size()) {
		    throw new FrameworkException(
			"Unequal number of option names / values!",
			this, container);
		}
	    }

	    Choice choices[] = new Choice[valueList.size()];
	    for (int count=0; count<valueList.size(); count++) {
		// FIXME: Do I18N
		choices[count] = new SimpleChoice(
		    optionList.get(count), valueList.get(count));
	    }
	    choice.setChoices(choices);
	}
	return choice;
    }


    /**
     *	OPTIONS are the 
     */
    public static final String	LABELS	= "labels";
    public static final String	VALUES	= "values";
}
