/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.view.descriptors;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.view.html.CheckBox;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ContainerView;
import com.sun.web.ui.view.html.CCCheckBox;


/**
 *
 */
public class CCCheckBoxDescriptor extends DisplayFieldDescriptor {
    
    private final String CHECKED_VALUE = "checkedValue";
    private final String UNCHECKED_VALUE= "uncheckedValue";

    /**
     * Constructor
     */
    public CCCheckBoxDescriptor(String name) {
	super(name);
    }


    /**
     *	This is a factory method for CheckBox instances.
     *
     *	@param	ctx	The RequestContext
     *	@param	container	The container for the newly created 
     */
    public View getInstance(RequestContext ctx, ContainerView container, String name) {
    	// Check to see if a default value was supplied, use "true" if not
    	Object value = 
	    getParameter(DisplayFieldDescriptor.DEFAULT_VALUE);
	boolean initialValue = true;
	if (value != null) {
	    initialValue = new Boolean(value.toString()).booleanValue();
	}

// FIXME: Support models
	// Create and return the CheckBox, with the values specified.
	// If the values are not specified use "true" for checked, "false" unchecked.
	Object checkedValue = getParameter(CHECKED_VALUE);
	Object uncheckedValue = getParameter(UNCHECKED_VALUE);

	if(checkedValue == null) {
	    checkedValue = "true";
	}
	if(uncheckedValue == null) {
	    uncheckedValue="false";
	}
	CheckBox checkbox =
	    new CCCheckBox(container, name, checkedValue, uncheckedValue, initialValue);
	setBoundName(checkbox);
	return checkbox;
    }
}
