/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.guiframework.event.handlers;

import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;

import java.util.EventObject;

import javax.servlet.ServletRequest;


/**
 *  This class provides a means to forward to another Page.
 */
public class NextPageHandler {

    /**
     *	This handler allows you to forward to another View ID.  You must
     *	specify the next page's id in a request attribute named "nextPage".
     */
    public void forwardTo(RequestContext ctx, HandlerContext handlerCtx) {
	String nextPage = (String)handlerCtx.getInputValue(NEXT_PAGE);
	if (nextPage == null) {
	    throw new IllegalArgumentException("The attribute '"+NEXT_PAGE+
		"' must be set to the ID of the next page to display!");
	}
	try {
	    ViewBean viewBean = ctx.getViewBeanManager().getViewBean(nextPage);
	    viewBean.forwardTo(ctx);
	} catch (ClassNotFoundException ex) {
	    throw new FrameworkException(
		"Unable to find the ViewBean specified by page id: " +
		nextPage, ex);
	}
    }

    /**
     *	<p> Use this handler to indicate that the Request has been handled.
     *	    This is needed if you manually forward to prevent the framework for
     *	    attempting to forward again, which would cause a problem.  This
     *	    handler does not require any parameters.</p>
     */
    public void markRequestComplete(RequestContext ctx, HandlerContext handlerCtx) {
	throw new CompleteRequestException();
    }



    //////////////////////////////////////////////////////////////////
    //	Class Variables
    //////////////////////////////////////////////////////////////////


    /**
     *	Request attribute key for the next page
     */
    public static final String NEXT_PAGE = "nextPage";
}
