/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.model.TreeModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ValidationException;


public interface IndexTreeModel extends TreeModel {
    /* Methods inherited from Model; listed here for reference.
    public String getName();
    public void setName(String value);
    public Object getValue(String name);
    public void setValue(String name, Object value);
    public Object[] getValues(String name);
    public void setValues(String name, Object[] values) throws ValidationException;
    */
    /* Methods inherited from TreeModel; listed here for reference.
    public String getNodeName() throws ModelControlException;
    public String getNodeType() throws ModelControlException;
    public int getNodeLevel();
    public String getNodeID();
    public boolean isParentNode();
    public boolean isChildNode();
    public int getTraversalType() throws ModelControlException;
    public void setTraversalType(int value) throws ModelControlException;
    public void beforeRoot() throws ModelControlException;
    public void root() throws ModelControlException;
    public boolean nextNode() throws ModelControlException;
    public boolean nextNode(int nextNodeType) throws ModelControlException;
    public boolean previousNode() throws ModelControlException;
    */
    public IndexTreeNode getNode(String nodePath) throws NodeNotFoundException;
    public IndexTreeNode getNodeByName(String nodeNamePath);
    public IndexTreeNode getNodeByUniqueID(String id, String ChildName, IndexTreeNode searchFrom);
    public Object getCurrentNode();
    public void setCurrentNode(String nodeID) throws ModelControlException, Exception;
    public void setCurrentNode(IndexTreeNode node);
    public String getNodeHID();
    public boolean firstChild() throws ModelControlException;
    public boolean parent() throws ModelControlException;
    public boolean nextSibling() throws ModelControlException;
    public String getIconName(boolean expanded);
    public boolean isInitialExpand();
    public String getType(String string);
    public IndexTreeNode getRoot();
    public void setRoot(IndexTreeNode node);
    public int getNextNodeID();
    public String getStateDataName();

    public static final String FIELD_ID         =   "id";
    public static final String FIELD_NAME       =   "name";
    public static final String FIELD_REFRESH    =   "refresh";
    public static final String FIELD_UNIQUEID   =   "UniqueID";    
    public static final String FIELD_DISPLAYNAME=   "displayName";

    // Node Types:
    public static final String CONTAINER = "container"; // a node with kids
    public static final String LEAF      = "leaf";      // a node with no kids
    public static final String ROOT      = "root";      // special case for the root node.
}
