/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 * $Header: /cvs/glassfish/admin-core/util/src/java/com/sun/enterprise/admin/util/ArrayConversion.java,v 1.2 2005/12/25 03:53:04 tcfujii Exp $
 * $Revision: 1.2 $
 * $Date: 2005/12/25 03:53:04 $
 */
 
package com.sun.enterprise.admin.util;

import java.lang.reflect.Array;

/*
	Provides methods to convert arrays of primitive types to corresponding
	arrays of Object types.
 */
public final class ArrayConversion
{
		private
	ArrayConversion( )
	{
		// disallow instantiation
	}
	
		private static Object []
	convert( Object simpleArray )
	{
		final String className	= simpleArray.getClass().getName();
		
		//final String	memberClassName	= ClassUtil.getArrayMemberClassName( className );
		
		final Class		theClass = ClassUtil.getArrayElementClass( simpleArray.getClass() );
		
		final int numItems	= Array.getLength( simpleArray );
		
		final Class elementClass	= ClassUtil.PrimitiveClassToObjectClass( theClass );
		
		final Object []	result	= (Object [])Array.newInstance( elementClass, numItems );
		
		for( int i = 0; i < numItems; ++i )
		{
			result[ i ]	= Array.get( simpleArray, i );
		}
		
		return( result );
	}
	
		public static Object []
	toAppropriateType( Object array)
	{
		return( (Object [])convert( array ) );
	}
	
	
		public static Boolean []
	toBooleans( boolean [] array )
	{
		return( (Boolean [])convert( array ) );
	}
	
		public static Character []
	toCharacters( char [] array )
	{
		return( (Character [])convert( array ) );
	}
	
		public static Byte []
	toBytes( byte [] array )
	{
		return( (Byte [])convert( array ) );
	}
	
		public static Short []
	toShorts( short [] array )
	{
		return( (Short [])convert( array ) );
	}
	
		public static Integer []
	toIntegers( int [] array )
	{
		return( (Integer [])convert( array ) );
	}
	
		public static Long []
	toLongs( long [] array )
	{
		return( (Long [])convert( array ) );
	}
	
		public static Float []
	toFloats( float [] array )
	{
		return( (Float [])convert( array ) );
	}
	
		public static Double []
	toDoubles( double [] array )
	{
		return( (Double [])convert( array ) );
	}
	
	
		public static Object []
	createObjectArrayType( final Class elementType, final int size )
		throws Exception
	{
		final Object [] result	= (Object []) Array.newInstance( elementType, size );
		
		return( result );
	}
	
		
		public static java.util.Set
	toSet( Object []	array )
	{
		java.util.Set	theSet	= null;
		if ( array.length == 0 )
		{
			theSet	= java.util.Collections.EMPTY_SET;
		}
		else if ( array.length == 1 )
		{
			theSet	= java.util.Collections.singleton( array[ 0 ] );
		}
		else
		{
			theSet	= new java.util.HashSet();
			for( int i = 0; i < array.length; ++i )
			{
				theSet.add( array[ i ] );
			}
		}
		return( theSet );
	}
	
	
		public static Object []
	setToArray( final java.util.Set s )
	{
		final java.util.Iterator	iter	= s.iterator();
		
		final Object []	out	= new Object [ s.size() ];
		
		return( setToArray( s, out ) );
	}
	
		public static Object []
	setToArray( final java.util.Set s, Object []	out )
	{
		final java.util.Iterator	iter	= s.iterator();
		
		if ( out.length != s.size() )
		{
			throw new IllegalArgumentException();
		}
		
		int	i = 0;
		while ( iter.hasNext() )
		{
			out[ i ]	= iter.next();
			++i;
		}
		
		return( out );
	}
}

