/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

/*
 * BoundedRangeStatisticImpl.java
 *
 * Created on August 8, 2003, 12:30 PM
 */

package com.sun.enterprise.admin.monitor.util;
import javax.management.j2ee.statistics.*;

/**
 * Mock BoundedRangeStatistic implementation
 * @author  sg112326
 */
public class BoundedRangeStatisticMock extends StatisticMock implements BoundedRangeStatistic {
    private long current=0;
    private long highWater=0;
    private long lowWater=0;
    private long upperBound=0;
    private long lowerBound=0;
    
    /** Creates a new instance of BoundedRangeStatisticImpl */
    public BoundedRangeStatisticMock(long current, long highWater, long lowWater,
    long upperBound, long lowerBound, String name,
    String unit, String desc, long sampleTime,
    long startTime) {
        super(name, unit, desc, startTime, sampleTime);
        this.current=current;
        this.highWater=highWater;
        this.lowWater=lowWater;
        this.upperBound=upperBound;
        this.lowerBound=lowerBound;
    }
    
    public long getCurrent() {
        System.out.println("returning current:"+current);
        return current;
    }
    
    public long getHighWaterMark() {
        return highWater;
    }
    
    public long getLowWaterMark() {
        return lowWater;
    }
    
    public long getLowerBound() {
        return lowerBound;
    }
    
    public long getUpperBound() {
        return upperBound;
    }
}
